package ru.yandex.direct.core.entity.banner.type.turbolandingparams;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingParams;
import ru.yandex.direct.core.entity.banner.type.turbolanding.BannerWithTurbolandingConstants;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerUriConstraints.hasNotInvalidEscapeSeq;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;

@Component
@ParametersAreNonnullByDefault
public class BannerWithTurboLandingParamsValidatorProvider {

    public Validator<BannerWithTurboLandingParams, Defect> validator() {
        return bannerWithTurboLandingParams -> {
            ModelItemValidationBuilder<BannerWithTurboLandingParams> ivb =
                    ModelItemValidationBuilder.of(bannerWithTurboLandingParams);
            ivb.item(BannerWithTurboLandingParams.TURBO_LANDING_HREF_PARAMS)
                    // bannerWithTurboLandingParams == null валидное значение, т.к. это поле опциональное
                    .checkBy(hrefParamsValidator(), When.notNull());
            return ivb.getResult();
        };
    }

    public static Validator<String, Defect> hrefParamsValidator() {
        return turboLandingParams ->
                ItemValidationBuilder.<String, Defect>of(turboLandingParams)
                        .check(maxStringLength(BannerWithTurbolandingConstants.MAX_LENGTH_TURBOLANDING_PARAMS))
                        .check(hasNotInvalidEscapeSeq())
                        .getResult();

    }

}
