package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class BannerVcardRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    public BannerVcardRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Получает список id баннеров по id привязанных к ним визиток
     *
     * @param shard    шард
     * @param vcardIds коллекция id визиток, для которых ищутся привязанные баннеры
     * @return мапа id визитки - список id привязанных к ней баннеров
     */
    public Map<Long, List<Long>> getBannerIdsByVcardIds(int shard, Collection<Long> vcardIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNERS.BID, BANNERS.VCARD_ID)
                .from(BANNERS)
                .where(BANNERS.VCARD_ID.in(vcardIds))
                .fetchGroups(BANNERS.VCARD_ID, BANNERS.BID);
    }
}
