package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.Map;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.vcard.BannerWithVcardConstraints.vcardBelongsToBannerCampaign;
import static ru.yandex.direct.core.entity.banner.type.vcard.BannerWithVcardConstraints.vcardExists;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

public class BannerVcardValidator implements Validator<Long, Defect> {

    private final Map<Long, Long> existingVcardIdToCampaignId;
    private final Long bannerCampaignId;

    public BannerVcardValidator(Map<Long, Long> existingVcardIdToCampaignId,
                                   Long bannerCampaignId) {
        this.existingVcardIdToCampaignId = existingVcardIdToCampaignId;
        this.bannerCampaignId = bannerCampaignId;
    }

    @Override
    public ValidationResult<Long, Defect> apply(Long vcardId) {
        return ItemValidationBuilder.<Long, Defect>of(vcardId)
                .check(validId())
                .check(vcardExists(existingVcardIdToCampaignId))
                .check(vcardBelongsToBannerCampaign(existingVcardIdToCampaignId, bannerCampaignId),
                        When.isValidAnd(When.isTrue(bannerCampaignId != null)))
                .getResult();
    }
}

