package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndVcard;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithOrganizationAndVcardUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithOrganizationAndVcard> {

    private final BannerWithOrganizationAndVcardValidatorProvider validatorProvider;

    @Autowired
    public BannerWithOrganizationAndVcardUpdateValidationTypeSupport(
            BannerWithOrganizationAndVcardValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithOrganizationAndVcard> getTypeClass() {
        return BannerWithOrganizationAndVcard.class;
    }

    @Override
    public ValidationResult<List<BannerWithOrganizationAndVcard>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithOrganizationAndVcard>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithOrganizationAndVcardValidator())
                .getResult();
    }
}
