package ru.yandex.direct.core.entity.banner.type.vcard;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndVcard;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndVcard.PREFER_V_CARD_OVER_PERMALINK;
import static ru.yandex.direct.core.entity.banner.type.vcard.BannerWithVcardConstraints.preferVcardOverPermalinkConsistentWithBannerSettings;

@Component
public class BannerWithOrganizationAndVcardValidatorProvider {

    public Validator<BannerWithOrganizationAndVcard, Defect> bannerWithOrganizationAndVcardValidator() {
        return banner -> {
            ModelItemValidationBuilder<BannerWithOrganizationAndVcard> builder =
                    ModelItemValidationBuilder.of(banner);

            builder.item(PREFER_V_CARD_OVER_PERMALINK)
                    .check(preferVcardOverPermalinkConsistentWithBannerSettings(banner));

            return builder.getResult();
        };
    }
}
