package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerVcardStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithVcard;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft;

@Component
public class BannerWithVcardAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithVcard> {

    @Override
    public Class<BannerWithVcard> getTypeClass() {
        return BannerWithVcard.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithVcard> models) {
        models.forEach(banner -> {
            var effectiveSaveDraft = isEffectiveSaveDraft(addContainer, banner);
            banner.setVcardStatusModerate(banner.getVcardId() == null || effectiveSaveDraft ?
                    BannerVcardStatusModerate.NEW : BannerVcardStatusModerate.READY);
        });
    }
}
