package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.Map;

import ru.yandex.direct.core.entity.banner.model.BannerWithOrganizationAndVcard;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.vcardNotFound;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.vcardOfAnotherCampaign;
import static ru.yandex.direct.core.entity.organizations.validation.OrganizationDefects.invalidPreferVCardOverPermalink;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

public class BannerWithVcardConstraints {

    private BannerWithVcardConstraints() {
        // only static methods
    }

    static Constraint<Long, Defect> vcardExists(Map<Long, Long> existingVcardIdToCampaignId) {
        return fromPredicate(existingVcardIdToCampaignId::containsKey,
                vcardNotFound());
    }

    static Constraint<Long, Defect> vcardBelongsToBannerCampaign(Map<Long, Long> existingVcardIdToCampaignId,
                                                                 Long bannerCampaignId) {
        return fromPredicate(vcardId -> {
                    Long vcardCampaignId = existingVcardIdToCampaignId.get(vcardId);
                    return bannerCampaignId.equals(vcardCampaignId);
                },
                vcardOfAnotherCampaign());
    }

    static Constraint<Boolean, Defect> preferVcardOverPermalinkConsistentWithBannerSettings(
            BannerWithOrganizationAndVcard banner) {
        return fromPredicate(preferFlag -> !preferFlag || canSetPreferVcardOverPermalink(banner),
                invalidPreferVCardOverPermalink());
    }

    private static Boolean canSetPreferVcardOverPermalink(BannerWithOrganizationAndVcard banner) {
        return banner.getVcardId() != null && banner.getPermalinkId() != null;
    }
}
