package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithVcardModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithVcardModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithVcardModeration> {

    private BannerWithChildrenModerationProvider<BannerWithVcardModeration> provider;

    @Autowired
    public BannerWithVcardModerationUpdateOperationTypeSupport(
            List<BannerWithVcardModerationProcessor<? extends BannerWithVcardModeration>> processors) {
        provider = new BannerWithChildrenModerationProvider<>(DefaultBannerWithVcardModerationProcessor.class,
                processors);
    }

    @Override
    public Class<BannerWithVcardModeration> getTypeClass() {
        return BannerWithVcardModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithVcardModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
