package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerVcardStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithVcard;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerRepositoryTypeSupport;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPaths;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPathsBuilder;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class BannerWithVcardRepositoryTypeSupport extends AbstractBannerRepositoryTypeSupport<BannerWithVcard> {

    private static final Set<ModelProperty<? super BannerWithVcard, ?>> GRUT_PROPERTIES =
            Set.of(BannerWithVcard.VCARD_ID);

    private static final JooqMapper<BannerWithVcard> MAPPER = createMapper();

    @Autowired
    public BannerWithVcardRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<BannerWithVcard> getTypeClass() {
        return BannerWithVcard.class;
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, BannerWithVcard model) {
        insertHelperAggregator.getOrCreate(BANNERS).add(MAPPER, model);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<BannerWithVcard>> appliedChanges) {
        updateHelperAggregator.getOrCreate(BANNERS.BID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends BannerWithVcard> void fillFromRecord(M model, Record record) {
        MAPPER.fromDb(record, model);
    }

    private static JooqMapper<BannerWithVcard> createMapper() {
        return JooqMapperBuilder.<BannerWithVcard>builder()
                .readProperty(BannerWithVcard.ID, fromField(BANNERS.BID))
                .map(property(BannerWithVcard.VCARD_ID, BANNERS.VCARD_ID))
                .map(convertibleProperty(BannerWithVcard.VCARD_STATUS_MODERATE,
                        BANNERS.PHONEFLAG,
                        BannerVcardStatusModerate::fromSource,
                        BannerVcardStatusModerate::toSource))
                .build();
    }

    @Override
    public Set<ModelProperty<? super BannerWithVcard, ?>> getGrutSupportedProperties() {
        return GRUT_PROPERTIES;
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(
            @NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
            @NotNull Collection<AppliedChanges<BannerWithVcard>> appliedChangesList,
            @NotNull BannersOperationContainer operationContainer) {
        Map<Long, ModifiedPaths> modifiedPathsMap = new HashMap<>();
        for (var appliedChanges : appliedChangesList) {
            if (appliedChanges.getPropertiesForUpdate().contains(BannerWithVcard.VCARD_ID)) {
                Long id = appliedChanges.getModel().getId();
                var newValue = appliedChanges.getNewValue(BannerWithVcard.VCARD_ID);
                ModifiedPaths modifiedPaths;
                if (newValue != null) {
                    Schema.TBannerV2.Builder bannerBuilder = bannerBuilders.get(id);
                    bannerBuilder.getSpecBuilder().setVcardId(newValue);

                    // Добавляем vcardId в список для предсоздания в груте зашлушки,
                    // если к моменту применения операции визитка ещё не отреплицировалась
                    modifiedPaths = new ModifiedPathsBuilder()
                            .withSetPaths(Set.of("/spec/vcard_id"))
                            .withVcardIdToCheckIfExist(newValue)
                            .build();
                } else {
                    modifiedPaths = new ModifiedPaths(emptySet(), Set.of("/spec/vcard_id"));
                }
                modifiedPathsMap.put(id, modifiedPaths);
            }
        }
        return modifiedPathsMap;
    }
}
