package ru.yandex.direct.core.entity.banner.type.vcard;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithVcard;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithVcardUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithVcard> {

    @Override
    public Class<BannerWithVcard> getTypeClass() {
        return BannerWithVcard.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithVcard> appliedChanges) {
        return appliedChanges.changed(BannerWithVcard.VCARD_ID);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithVcard> appliedChanges) {
        return appliedChanges.changed(BannerWithVcard.VCARD_ID);
    }
}
