package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithVcard;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithVcardUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithVcard> {

    private final BannerWithVcardValidatorProvider validatorProvider;

    @Autowired
    public BannerWithVcardUpdateValidationTypeSupport(
            BannerWithVcardValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithVcard> getTypeClass() {
        return BannerWithVcard.class;
    }

    @Override
    public ValidationResult<List<BannerWithVcard>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithVcard>, Defect> vr) {
        if (container.isPartOfComplexOperation()) {
            return vr;
        }

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithVcardValidator(container))
                .getResult();
    }
}
