package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.List;
import java.util.Objects;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.BannerWithVcard;

public class BannerWithVcardUtils {
    private BannerWithVcardUtils() {
    }

    public static boolean hasCommonVcard(List<BannerWithVcard> banners) {
        return allBannersVcardIdEquals(banners) && allBannersHasVcardId(banners);
    }

    private static boolean allBannersHasVcardId(List<BannerWithVcard> banners) {
        return StreamEx.of(banners)
                .map(BannerWithVcard::getVcardId)
                .allMatch(Objects::nonNull);
    }

    private static boolean allBannersVcardIdEquals(List<BannerWithVcard> banners) {
        return StreamEx.of(banners)
                .map(BannerWithVcard::getVcardId)
                .nonNull()
                .distinct()
                .limit(2)
                .count() == 1;
    }
}
