package ru.yandex.direct.core.entity.banner.type.vcard;

import java.util.Map;

import one.util.streamex.EntryStream;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithVcard;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerWithVcard.VCARD_ID;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@Component
public class BannerWithVcardValidatorProvider {

    public Validator<BannerWithVcard, Defect> bannerWithVcardValidator(BannersOperationContainer container) {

        var vcardMap = container.getVcardIdToData();
        Map<Long, Long> existingVcardIdToCampaignId = EntryStream.of(vcardMap)
                .mapValues(Vcard::getCampaignId)
                .toMap();

        return banner -> {
            AdGroupForBannerOperation adGroup = container.getAdGroup(banner);
            Long bannerCampaignId = ifNotNull(adGroup, AdGroupForBannerOperation::getCampaignId);

            ModelItemValidationBuilder<BannerWithVcard> builder = ModelItemValidationBuilder.of(banner);

            builder.item(VCARD_ID)
                    .checkBy(new BannerVcardValidator(existingVcardIdToCampaignId, bannerCampaignId));

            return builder.getResult();
        };
    }
}
