package ru.yandex.direct.core.entity.banner.type.video;

import java.util.Collection;
import java.util.List;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithVideo;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;


@Component
public class BannerWithVideoRepositoryTypeSupport
        extends AbstractBannerRepositoryTypeSupport<BannerWithVideo> {

    private final JooqReader<BannerWithVideo> reader;

    @Autowired
    public BannerWithVideoRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
        reader = createReader();
    }

    @Override
    public Collection<Field<?>> getFields() {
        return reader.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(PHRASES, JoinType.JOIN, PHRASES.PID.eq(BANNERS.PID)));
    }

    @Override
    public <M extends BannerWithVideo> void fillFromRecord(M model, Record record) {
        reader.fromDb(record, model);
    }

    @Override
    public Class<BannerWithVideo> getTypeClass() {
        return BannerWithVideo.class;
    }

    private static JooqReader<BannerWithVideo> createReader() {
        return JooqReaderBuilder.<BannerWithVideo>builder()
                .readProperty(BannerWithVideo.IS_MOBILE_VIDEO, fromField(PHRASES.ADGROUP_TYPE)
                        .by(type -> type == PhrasesAdgroupType.mobile_content))
                .build();
    }
}
