package ru.yandex.direct.core.entity.banner.type.zenpublisherid;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithZenPublisherId;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractRelatedSingleFieldRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerPublisherRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PUBLISHER;

@Component
@ParametersAreNonnullByDefault
public class BannerWithZenPublisherIdRepositoryTypeSupport
        extends AbstractRelatedSingleFieldRepositoryTypeSupport<BannerWithZenPublisherId, String, BannerPublisherRecord, String> {

    @Autowired
    public BannerWithZenPublisherIdRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider,
                BannerWithZenPublisherId.ZEN_PUBLISHER_ID,
                BANNER_PUBLISHER.BID,
                BANNER_PUBLISHER.ZEN_PUBLISHER_ID,
                Function.identity(),
                Function.identity());
    }

    @Override
    public Class<BannerWithZenPublisherId> getTypeClass() {
        return BannerWithZenPublisherId.class;
    }

}
