package ru.yandex.direct.core.entity.banner.type.zenpublisherid;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithZenPublisherId;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithZenPublisherIdUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithZenPublisherId> {

    @Override
    public Class<BannerWithZenPublisherId> getTypeClass() {
        return BannerWithZenPublisherId.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithZenPublisherId> appliedChanges) {
        return appliedChanges.changed(BannerWithZenPublisherId.ZEN_PUBLISHER_ID);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithZenPublisherId> appliedChanges) {
        return appliedChanges.changed(BannerWithZenPublisherId.ZEN_PUBLISHER_ID);
    }

}
