package ru.yandex.direct.core.entity.bidmodifiers;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;

import ru.yandex.direct.core.entity.bidmodifier.AgeType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.GenderType;
import ru.yandex.direct.core.entity.bidmodifier.InventoryType;
import ru.yandex.direct.core.entity.bidmodifier.OperationType;
import ru.yandex.direct.core.entity.bidmodifier.TrafaretPosition;
import ru.yandex.direct.core.entity.bidmodifier.WeatherType;
import ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionParameter;
import ru.yandex.direct.core.entity.bidmodifiers.expression.ParameterInfo;
import ru.yandex.direct.core.entity.bidmodifiers.repository.BidModifierLevel;

import static java.util.Collections.unmodifiableSet;
import static ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionOperator.EQ;
import static ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionOperator.GE;
import static ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionOperator.GT;
import static ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionOperator.LE;
import static ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionOperator.LT;
import static ru.yandex.direct.core.entity.bidmodifiers.expression.ParameterInfo.enumParameter;
import static ru.yandex.direct.core.entity.bidmodifiers.expression.ParameterInfo.integerParameter;

public class Constants {
    public static final int DEMOGRAPHICS_ADJUSTMENTS_LIMIT = 12;

    public static final int WEATHER_ADJUSTMENTS_LIMIT = 20;

    public static final int RETARGETING_ADJUSTMENTS_LIMIT = 100;

    public static final int RETARGETING_FILTER_LIMIT = 50;

    public static final int INVENTORY_ADJUSTMENTS_LIMIT = EnumSet.allOf(InventoryType.class).size();

    public static final int TRAFARET_POSITION_ADJUSTMENTS_LIMIT = EnumSet.allOf(TrafaretPosition.class).size();

    public static final int CONTENT_DURATION_ADJUSTMENTS_LIMIT = 2;

    public static final int PRISMA_INCOME_GRADE_ADJUSTMENTS_LIMIT = 4;

    public static final Set<BidModifierLevel> ALL_LEVELS = ImmutableSet.copyOf(EnumSet.allOf(BidModifierLevel.class));

    public static final Set<GenderType> ALL_GENDERS = ImmutableSet.of(GenderType.MALE, GenderType.FEMALE);

    public static final Set<AgeType> ALL_AGES = ImmutableSet.of(
            AgeType._0_17, AgeType._18_24, AgeType._25_34, AgeType._35_44, AgeType._45_54, AgeType._55_);

    /**
     * Если пользователь указывает старый диапазон "45+", мы его сохраняем как есть (выдавая варнинг о том,
     * что нужно переходить на новые диапазоны), но при валидации считаем его как комбинацию "45-54" и "55+"
     */
    public static final Set<AgeType> OLD_AGE_45_EXPANSION = ImmutableSet.of(AgeType._45_54, AgeType._55_);

    public static final Set<Integer> PREC_STRENGTH_VALUES = ImmutableSet.of(0, 25, 50, 75, 100);
    public static final Set<Integer> CLOUDNESS_VALUES = ImmutableSet.of(0, 25, 50, 75, 100);
    public static final Integer MAX_TEMP_VALUE = 50;
    public static final Integer MIN_TEMP_VALUE = -50;

    public static final Set<WeatherType> WEATHER_MULTIPLIER_EXPRESSION_AVAILABLE_PARAMETER =
            ImmutableSet.of(WeatherType.CLOUDNESS, WeatherType.PREC_STRENGTH, WeatherType.TEMP);

    public static final ImmutableMap<WeatherType, ImmutableSet<OperationType>>
            WEATHER_MULTIPLIER_EXPRESSION_AVAILABLE_OPERATIONS =
            ImmutableMap.<WeatherType, ImmutableSet<OperationType>>builder()
                    .put(WeatherType.TEMP, ImmutableSet.of(OperationType.GE, OperationType.LE))
                    .put(WeatherType.CLOUDNESS, ImmutableSet.of(OperationType.EQ))
                    .put(WeatherType.PREC_STRENGTH, ImmutableSet.of(OperationType.EQ))
                    .build();

    private static final Map<BidModifierExpressionParameter, ParameterInfo> TRAFFIC_PARAMETERS =
            ImmutableMap.<BidModifierExpressionParameter, ParameterInfo>builder()
                    .put(BidModifierExpressionParameter.TRAFFIC_JAM,
                            enumParameter(
                                    // FREE, LIGHT, HARD, VERY_HARD
                                    // https://st.yandex-team.ru/DOOH-1322
                                    Set.of("0", "1", "2", "3"),
                                    ImmutableSet.of(EQ)))
                    .build();

    private static final int MIN_VIDEO_CONTENT_DURATION = 59;
    private static final int MAX_VIDEO_CONTENT_DURATION = 60 * 60;
    private static final Map<BidModifierExpressionParameter, ParameterInfo> CONTENT_DURATION_PARAMETERS =
            ImmutableMap.<BidModifierExpressionParameter, ParameterInfo>builder()
                    .put(BidModifierExpressionParameter.VIDEO_CONTENT_DURATION,
                            integerParameter(MIN_VIDEO_CONTENT_DURATION, MAX_VIDEO_CONTENT_DURATION, Set.of(GE, LE,
                                    GT, LT)))
                    .build();

    //TODO adjust enum parameters of grades
    private static final Map<BidModifierExpressionParameter, ParameterInfo> PRISMA_INCOME_GRADE_PARAMETERS =
            ImmutableMap.<BidModifierExpressionParameter, ParameterInfo>builder()
                    .put(
                            BidModifierExpressionParameter.PRISMA_INCOME_GRADE,
                            enumParameter(
                                    // ABOVE_AVERAGE, HIGH, VERY_HIGH
                                    // Кластеры Призмы
                                    // 0: 91-95, 1: 96-99, 2: 100
                                    ImmutableSet.of("0", "1", "2"),
                                    ImmutableSet.of(EQ))
                    ).build();
    /**
     * Для каждого типа expression-корректировок определяем метаданные по параметрам и их ограничениям.
     */
    public static final Map<BidModifierType, Map<BidModifierExpressionParameter, ParameterInfo>> ALL_PARAMETERS =
            ImmutableMap.<BidModifierType, Map<BidModifierExpressionParameter, ParameterInfo>>builder()
                    .put(BidModifierType.EXPRESS_TRAFFIC_MULTIPLIER, TRAFFIC_PARAMETERS)
                    .put(BidModifierType.EXPRESS_CONTENT_DURATION_MULTIPLIER, CONTENT_DURATION_PARAMETERS)
                    .put(BidModifierType.PRISMA_INCOME_GRADE_MULTIPLIER, PRISMA_INCOME_GRADE_PARAMETERS)
                    .build();

    /**
     * Все типы expression-корректировок.
     */
    public static final Set<BidModifierType> EXPRESSION_MODIFIER_TYPES = unmodifiableSet(ALL_PARAMETERS.keySet());

    public static final Set<BidModifierType> ALL_TYPES = Sets.union(
            Set.of(
                    BidModifierType.MOBILE_MULTIPLIER,
                    BidModifierType.TABLET_MULTIPLIER,
                    BidModifierType.DEMOGRAPHY_MULTIPLIER,
                    BidModifierType.RETARGETING_MULTIPLIER,
                    BidModifierType.GEO_MULTIPLIER,
                    BidModifierType.VIDEO_MULTIPLIER,
                    BidModifierType.PERFORMANCE_TGO_MULTIPLIER,
                    BidModifierType.AB_SEGMENT_MULTIPLIER,
                    BidModifierType.BANNER_TYPE_MULTIPLIER,
                    BidModifierType.INVENTORY_MULTIPLIER,
                    BidModifierType.DESKTOP_MULTIPLIER,
                    BidModifierType.DESKTOP_ONLY_MULTIPLIER,
                    BidModifierType.SMARTTV_MULTIPLIER,
                    BidModifierType.WEATHER_MULTIPLIER,
                    BidModifierType.TRAFARET_POSITION_MULTIPLIER
            ),
            EXPRESSION_MODIFIER_TYPES
    );

    public static final Set<BidModifierType> ALL_TYPES_INTERNAL = Sets.union(
            ALL_TYPES,
            Set.of(BidModifierType.RETARGETING_FILTER)
    );
}
