package ru.yandex.direct.core.entity.bidmodifiers.container;

import java.util.List;

/**
 * Результат добавления набора корректировок.
 * Идентификаторы здесь записываются во внутреннем формате (без префиксов).
 */
public class AddedBidModifierInfo {
    private static final AddedBidModifierInfo NOT_ADDED = new AddedBidModifierInfo(false, null);

    private final boolean added;
    private final List<Long> ids;

    private AddedBidModifierInfo(boolean added, List<Long> ids) {
        this.added = added;
        this.ids = ids;
    }

    public static AddedBidModifierInfo notAdded() {
        return NOT_ADDED;
    }

    public static AddedBidModifierInfo added(List<Long> ids) {
        return new AddedBidModifierInfo(true, ids);
    }

    public boolean isAdded() {
        return added;
    }

    public List<Long> getIds() {
        return ids;
    }
}
