package ru.yandex.direct.core.entity.bidmodifiers.container;

import java.util.Objects;

import javax.annotation.Nullable;

import com.google.common.base.Preconditions;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;

/**
 * Ключ, уникально идентифицирующий набор корректировок.
 */
public final class BidModifierKey {
    private long campaignId;
    @Nullable
    private Long adGroupId;
    private BidModifierType type;

    public BidModifierKey(long campaignId, @Nullable Long adGroupId, BidModifierType type) {
        Preconditions.checkNotNull(type);
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.type = type;
    }

    /**
     * Конструктор для bidModifier, у которых campaignId != null.
     */
    public BidModifierKey(BidModifier bidModifier) {
        this(Preconditions.checkNotNull(bidModifier.getCampaignId()), bidModifier.getAdGroupId(),
                bidModifier.getType());
    }

    public long getCampaignId() {
        return campaignId;
    }

    @Nullable
    public Long getAdGroupId() {
        return adGroupId;
    }

    public BidModifierType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BidModifierKey that = (BidModifierKey) o;
        return campaignId == that.campaignId &&
                Objects.equals(adGroupId, that.adGroupId) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, adGroupId, type);
    }

    @Override
    public String toString() {
        return "BidModifierKey{" +
                "type=" + type +
                ", campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                '}';
    }
}
