package ru.yandex.direct.core.entity.bidmodifiers.container;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierABSegment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierBannerType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktop;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopOnly;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierExpression;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierGeo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventory;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobile;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargeting;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierSmartTV;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTablet;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTrafaretPosition;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeather;
import ru.yandex.direct.core.entity.bidmodifier.ComplexBidModifier;

public class ComplexBidModifierConverter {
    public static ComplexBidModifier convertToComplexBidModifier(List<BidModifier> bidModifiers) {
        if (bidModifiers == null || bidModifiers.isEmpty()) {
            return null;
        }

        ComplexBidModifier complexBidModifier = new ComplexBidModifier();

        for (BidModifier bidModifier : bidModifiers) {
            switch (bidModifier.getType()) {
                case MOBILE_MULTIPLIER: {
                    complexBidModifier.withMobileModifier((BidModifierMobile) bidModifier);
                    break;
                }
                case DESKTOP_MULTIPLIER: {
                    complexBidModifier.withDesktopModifier((BidModifierDesktop) bidModifier);
                    break;
                }
                case TABLET_MULTIPLIER: {
                    complexBidModifier.withTabletModifier((BidModifierTablet) bidModifier);
                    break;
                }
                case DESKTOP_ONLY_MULTIPLIER: {
                    complexBidModifier.withDesktopOnlyModifier((BidModifierDesktopOnly) bidModifier);
                    break;
                }
                case SMARTTV_MULTIPLIER: {
                    complexBidModifier.withSmartTVModifier((BidModifierSmartTV) bidModifier);
                    break;
                }
                case VIDEO_MULTIPLIER: {
                    complexBidModifier.withVideoModifier((BidModifierVideo) bidModifier);
                    break;
                }
                case PERFORMANCE_TGO_MULTIPLIER: {
                    complexBidModifier.withPerformanceTgoModifier((BidModifierPerformanceTgo) bidModifier);
                    break;
                }
                case DEMOGRAPHY_MULTIPLIER: {
                    complexBidModifier.withDemographyModifier((BidModifierDemographics) bidModifier);
                    break;
                }
                case WEATHER_MULTIPLIER: {
                    complexBidModifier.withWeatherModifier((BidModifierWeather) bidModifier);
                    break;
                }
                case GEO_MULTIPLIER: {
                    complexBidModifier.withGeoModifier((BidModifierGeo) bidModifier);
                    break;
                }
                case RETARGETING_MULTIPLIER: {
                    complexBidModifier.withRetargetingModifier((BidModifierRetargeting) bidModifier);
                    break;
                }
                case AB_SEGMENT_MULTIPLIER: {
                    complexBidModifier.withAbSegmentModifier((BidModifierABSegment) bidModifier);
                    break;
                }
                case INVENTORY_MULTIPLIER: {
                    complexBidModifier.withInventoryModifier((BidModifierInventory) bidModifier);
                    break;
                }
                case BANNER_TYPE_MULTIPLIER: {
                    complexBidModifier.withBannerTypeModifier((BidModifierBannerType) bidModifier);
                    break;
                }
                case EXPRESS_TRAFFIC_MULTIPLIER:
                case PRISMA_INCOME_GRADE_MULTIPLIER: {
                    if (complexBidModifier.getExpressionModifiers() == null) {
                        complexBidModifier.setExpressionModifiers(new ArrayList<>());
                    }
                    complexBidModifier.getExpressionModifiers().add((BidModifierExpression) bidModifier);
                    break;
                }
                case TRAFARET_POSITION_MULTIPLIER: {
                    complexBidModifier.withTrafaretPositionModifier((BidModifierTrafaretPosition) bidModifier);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown bid modifier type: " + bidModifier.getType());
                }
            }
        }

        return complexBidModifier;
    }
}
