package ru.yandex.direct.core.entity.bidmodifiers.repository.mapper;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionOperator;
import ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionParameter;

/**
 * Класс для сохранения условий expression-корректировок в виде JSON.
 * Нужен для того, чтобы value хранить в одном поле, а не в нескольких, как в модели.
 * При загрузке из базы наоборот определяем, значение какого типа было прочитано, и записываем его в нужное поле.
 */
public class BidModifierExpressionLiteralDb {
    @JsonProperty("parameter")
    public BidModifierExpressionParameter parameter;
    @JsonProperty("operation")
    public BidModifierExpressionOperator operation;
    @JsonProperty("value")
    public Object value;

    public BidModifierExpressionLiteralDb() {
    }

    public BidModifierExpressionLiteralDb(BidModifierExpressionParameter parameter,
                                          BidModifierExpressionOperator operation, Object value) {
        this.parameter = parameter;
        this.operation = operation;
        this.value = value;
    }
}
