package ru.yandex.direct.core.entity.bidmodifiers.repository.mapper;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Preconditions;
import one.util.streamex.StreamEx;
import org.jooq.Field;
import org.jooq.types.ULong;

import ru.yandex.direct.common.jooqmapper.FieldMapper;
import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.bidmodifier.AbstractBidModifierRetargetingAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.AgeType;
import ru.yandex.direct.core.entity.bidmodifier.BannerType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierABSegment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierABSegmentAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierBannerType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierBannerTypeAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographicsAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktop;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopOnly;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopOnlyAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierExpressionAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierGeo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventory;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventoryAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobile;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobileAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgoAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRegionalAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargeting;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingFilter;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingFilterAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierSmartTV;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierSmartTVAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTablet;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTabletAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTrafaretPosition;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTrafaretPositionAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideoAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeather;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeatherAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeatherLiteral;
import ru.yandex.direct.core.entity.bidmodifier.GenderType;
import ru.yandex.direct.core.entity.bidmodifier.InventoryType;
import ru.yandex.direct.core.entity.bidmodifier.TrafaretPosition;
import ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionLiteral;
import ru.yandex.direct.dbschema.ppc.enums.HierarchicalMultipliersType;
import ru.yandex.direct.dbschema.ppc.tables.records.RetargetingGoalsRecord;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.utils.HashingUtils;
import ru.yandex.direct.utils.JsonUtils;

import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.ObjectUtils.firstNonNull;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.convertibleField;
import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.integerProperty;
import static ru.yandex.direct.dbschema.ppc.Tables.AB_SEGMENT_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TYPE_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.DEMOGRAPHY_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.EXPRESSION_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.GEO_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.INVENTORY_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.RETARGETING_GOALS;
import static ru.yandex.direct.dbschema.ppc.Tables.RETARGETING_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.TRAFARET_POSITION_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.WEATHER_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.tables.HierarchicalMultipliers.HIERARCHICAL_MULTIPLIERS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromFields;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperties;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class Common {
    public static final Collection<Field<?>> ALL_BIDMODIFIER_FIELDS;
    public static final Collection<Field<?>> DEMOGRAPHY_ADJUSTMENT_FIELDS;
    public static final Collection<Field<?>> WEATHER_ADJUSTMENT_FIELDS;
    public static final Collection<Field<?>> REGIONAL_ADJUSTMENT_FIELDS;
    public static final Collection<Field<?>> RETARGETING_ADJUSTMENT_FIELDS;
    public static final Collection<Field<?>> AB_SEGMENT_ADJUSTMENT_FIELDS;
    public static final Collection<Field<?>> BANNER_TYPE_ADJUSTMENT_FIELDS;
    public static final Collection<Field<?>> INVENTORY_ADJUSTMENT_FIELDS;
    public static final Collection<Field<?>> EXPRESSION_ADJUSTMENT_FIELDS;
    public static final Collection<Field<?>> TRAFARET_POSITION_ADJUSTMENT_FIELDS;

    // Тип для десериализации корректировки по погоде
    private static final JavaType WEATHER_CONDITION_JSON_TYPE = TypeFactory.defaultInstance()
            .constructCollectionType(
                    List.class, TypeFactory.defaultInstance()
                            .constructCollectionType(List.class, BidModifierWeatherLiteral.class));

    // Тип для десериализации универсальных корректировок
    public static final JavaType EXPRESSION_CONDITION_JSON_TYPE = TypeFactory.defaultInstance()
            .constructCollectionType(
                    List.class, TypeFactory.defaultInstance()
                            .constructCollectionType(List.class, BidModifierExpressionLiteralDb.class));

    public static List<List<BidModifierExpressionLiteralDb>> conditionToDb(List<List<BidModifierExpressionLiteral>> condition) {
        return condition.stream().map(subCondition -> subCondition.stream().map(
                literal -> new BidModifierExpressionLiteralDb(
                        literal.getParameter(),
                        literal.getOperation(),
                        firstNonNull(literal.getValueInteger(),
                                literal.getValueString())
                )
        ).collect(toList())).collect(toList());
    }

    public static List<List<BidModifierExpressionLiteral>> conditionFromDb(List<List<BidModifierExpressionLiteralDb>> conditionDb) {
        return conditionDb.stream().map(subCondition -> subCondition.stream().map(literalDb ->
                        new BidModifierExpressionLiteral()
                                .withParameter(literalDb.parameter)
                                .withOperation(literalDb.operation)
                                .withValueInteger(literalDb.value instanceof Integer ? (Integer) literalDb.value : null)
                                .withValueString(literalDb.value instanceof String ? (String) literalDb.value : null)
                ).collect(toList())
        ).collect(toList());
    }

    public static final JooqMapper<BidModifier> BASE_MAPPER =
            JooqMapperBuilder.<BidModifier>builder()
                    .map(property(BidModifier.ID, HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID))
                    .map(property(BidModifier.CAMPAIGN_ID, HIERARCHICAL_MULTIPLIERS.CID))
                    .map(property(BidModifier.AD_GROUP_ID, HIERARCHICAL_MULTIPLIERS.PID))
                    .map(convertibleProperty(BidModifier.TYPE, HIERARCHICAL_MULTIPLIERS.TYPE,
                            BidModifierType::fromSource, BidModifierType::toSource))
                    .writeField(HIERARCHICAL_MULTIPLIERS.SYNTETIC_KEY_HASH,
                            fromProperties(BidModifier.TYPE, BidModifier.CAMPAIGN_ID, BidModifier.AD_GROUP_ID)
                                    .by((type, campaignId, adGroupId) ->
                                            ULong.valueOf(computeSyntheticKeyHash(type, campaignId, adGroupId))))
                    .map(booleanProperty(BidModifier.ENABLED, HIERARCHICAL_MULTIPLIERS.IS_ENABLED))
                    .map(property(BidModifier.LAST_CHANGE, HIERARCHICAL_MULTIPLIERS.LAST_CHANGE))
                    .build();

    private static final Supplier<BidModifierMobile>
            BID_MODIFIER_MOBILE_WITH_ADJUSTMENT_SUPPLIER =
            () -> new BidModifierMobile().withMobileAdjustment(new BidModifierMobileAdjustment());

    public static final JooqMapperWithSupplier<BidModifierMobile> MOBILE_MAPPER_WITHOUT_OS_TYPE =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BID_MODIFIER_MOBILE_WITH_ADJUSTMENT_SUPPLIER)
                    .readProperty(BidModifierMobile.MOBILE_ADJUSTMENT,
                            fromFields(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID,
                                    HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT, HIERARCHICAL_MULTIPLIERS.LAST_CHANGE)
                                    .by((id, percent, lastChange) -> new BidModifierMobileAdjustment()
                                            .withId(id)
                                            .withPercent(ifNotNull(percent, Long::intValue))
                                            .withLastChange(lastChange)))
                    .writeField(HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT,
                            fromProperty(BidModifierMobile.MOBILE_ADJUSTMENT)
                                    .by(mobileAdjustment -> mobileAdjustment.getPercent().longValue()))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierMobile> MOBILE_MAPPER_WITH_OS_TYPE =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BID_MODIFIER_MOBILE_WITH_ADJUSTMENT_SUPPLIER)
                    .build();

    private static final Supplier<BidModifierTablet>
            BID_MODIFIER_TABLET_WITH_ADJUSTMENT_SUPPLIER =
            () -> new BidModifierTablet().withTabletAdjustment(new BidModifierTabletAdjustment());

    public static final JooqMapperWithSupplier<BidModifierTablet> TABLET_MAPPER_WITHOUT_OS_TYPE =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BID_MODIFIER_TABLET_WITH_ADJUSTMENT_SUPPLIER)
                    .readProperty(BidModifierTablet.TABLET_ADJUSTMENT,
                            fromFields(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID,
                                    HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT, HIERARCHICAL_MULTIPLIERS.LAST_CHANGE)
                                    .by((id, percent, lastChange) -> new BidModifierTabletAdjustment()
                                            .withId(id)
                                            .withPercent(ifNotNull(percent, Long::intValue))
                                            .withLastChange(lastChange)))
                    .writeField(HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT,
                            fromProperty(BidModifierTablet.TABLET_ADJUSTMENT)
                                    .by(tabletAdjustment -> tabletAdjustment.getPercent().longValue()))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierTablet> TABLET_MAPPER_WITH_OS_TYPE =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BID_MODIFIER_TABLET_WITH_ADJUSTMENT_SUPPLIER)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierDesktop> DESKTOP_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierDesktop::new)
                    .readProperty(BidModifierDesktop.DESKTOP_ADJUSTMENT,
                            fromFields(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID,
                                    HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT)
                                    .by((id, percent) -> new BidModifierDesktopAdjustment()
                                            .withId(id)
                                            .withPercent(percent.intValue())))
                    .writeField(HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT,
                            fromProperty(BidModifierDesktop.DESKTOP_ADJUSTMENT)
                                    .by(desktopAdjustment -> desktopAdjustment.getPercent().longValue()))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierDesktopOnly> DESKTOP_ONLY_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierDesktopOnly::new)
                    .readProperty(BidModifierDesktopOnly.DESKTOP_ONLY_ADJUSTMENT,
                            fromFields(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID,
                                    HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT)
                                    .by((id, percent) -> new BidModifierDesktopOnlyAdjustment()
                                            .withId(id)
                                            .withPercent(percent.intValue())))
                    .writeField(HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT,
                            fromProperty(BidModifierDesktopOnly.DESKTOP_ONLY_ADJUSTMENT)
                                    .by(desktopAdjustment -> desktopAdjustment.getPercent().longValue()))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierSmartTV> SMARTTV_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierSmartTV::new)
                    .readProperty(BidModifierSmartTV.SMART_T_V_ADJUSTMENT,
                            fromFields(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID,
                                    HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT)
                                    .by((id, percent) -> new BidModifierSmartTVAdjustment()
                                            .withId(id)
                                            .withPercent(percent.intValue())))
                    .writeField(HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT,
                            fromProperty(BidModifierSmartTV.SMART_T_V_ADJUSTMENT)
                                    .by(smartTVAdjustment -> smartTVAdjustment.getPercent().longValue()))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierVideo> VIDEO_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierVideo::new)
                    .readProperty(BidModifierVideo.VIDEO_ADJUSTMENT,
                            fromFields(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID,
                                    HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT)
                                    .by((id, percent) -> new BidModifierVideoAdjustment()
                                            .withId(id)
                                            .withPercent(percent.intValue())))
                    .writeField(HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT,
                            fromProperty(BidModifierVideo.VIDEO_ADJUSTMENT)
                                    .by(videoAdjustment -> videoAdjustment.getPercent().longValue()))
                    .build();


    public static final JooqMapperWithSupplier<BidModifierABSegment> AB_SEGMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierABSegment::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierBannerType> BANNER_TYPE_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierBannerType::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierInventory> INVENTORY_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierInventory::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierPerformanceTgo> PERFORMANCE_TGO_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierPerformanceTgo::new)
                    .readProperty(BidModifierPerformanceTgo.PERFORMANCE_TGO_ADJUSTMENT,
                            fromFields(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID,
                                    HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT)
                                    .by((id, percent) -> new BidModifierPerformanceTgoAdjustment()
                                            .withId(id)
                                            .withPercent(percent.intValue())))
                    .writeField(HIERARCHICAL_MULTIPLIERS.MULTIPLIER_PCT,
                            fromProperty(BidModifierPerformanceTgo.PERFORMANCE_TGO_ADJUSTMENT)
                                    .by(performanceTgoAdjustment -> performanceTgoAdjustment.getPercent().longValue()))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierDemographics> DEMOGRAPHICS_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierDemographics::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierWeather> WEATHER_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierWeather::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierGeo> GEO_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierGeo::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierRetargeting> RETARGETING_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierRetargeting::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierRetargetingFilter> RETARGETING_FILTER_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierRetargetingFilter::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierTrafaretPosition> TRAFARET_POSITION_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BASE_MAPPER, BidModifierTrafaretPosition::new)
                    .build();

    public static final JooqMapperWithSupplier<BidModifierDemographicsAdjustment>
            DEMOGRAPHY_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierDemographicsAdjustment::new)
                    .map(property(BidModifierDemographicsAdjustment.ID,
                            DEMOGRAPHY_MULTIPLIER_VALUES.DEMOGRAPHY_MULTIPLIER_VALUE_ID))
                    .map(convertibleProperty(BidModifierDemographicsAdjustment.AGE, DEMOGRAPHY_MULTIPLIER_VALUES.AGE,
                            AgeType::fromSource, AgeType::toSource))
                    .map(convertibleProperty(BidModifierDemographicsAdjustment.GENDER,
                            DEMOGRAPHY_MULTIPLIER_VALUES.GENDER,
                            GenderType::fromSource, GenderType::toSource))
                    .map(integerProperty(BidModifierDemographicsAdjustment.PERCENT,
                            DEMOGRAPHY_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierDemographicsAdjustment.LAST_CHANGE,
                            DEMOGRAPHY_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierWeatherAdjustment> WEATHER_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierWeatherAdjustment::new)
                    .map(property(BidModifierWeatherAdjustment.ID,
                            WEATHER_MULTIPLIER_VALUES.WEATHER_MULTIPLIER_VALUE_ID))
                    .map(convertibleProperty(BidModifierWeatherAdjustment.EXPRESSION,
                            WEATHER_MULTIPLIER_VALUES.CONDITION_JSON,
                            json -> JsonUtils.fromJson(json, WEATHER_CONDITION_JSON_TYPE), JsonUtils::toJson))
                    .map(integerProperty(BidModifierWeatherAdjustment.PERCENT,
                            WEATHER_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierWeatherAdjustment.LAST_CHANGE, WEATHER_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapper<BidModifierExpressionAdjustment> EXPRESSION_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.<BidModifierExpressionAdjustment>builder()
                    .map(property(BidModifierExpressionAdjustment.ID,
                            EXPRESSION_MULTIPLIER_VALUES.EXPRESSION_MULTIPLIER_VALUE_ID))
                    .map(convertibleProperty(BidModifierExpressionAdjustment.CONDITION,
                            EXPRESSION_MULTIPLIER_VALUES.CONDITION_JSON,
                            json -> conditionFromDb(JsonUtils.fromJson(json, EXPRESSION_CONDITION_JSON_TYPE)),
                            condition -> JsonUtils.toJson(conditionToDb(condition))))
                    .map(integerProperty(BidModifierExpressionAdjustment.PERCENT,
                            EXPRESSION_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierExpressionAdjustment.LAST_CHANGE,
                            EXPRESSION_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierRegionalAdjustment> REGIONAL_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierRegionalAdjustment::new)
                    .map(property(BidModifierRegionalAdjustment.ID, GEO_MULTIPLIER_VALUES.GEO_MULTIPLIER_VALUE_ID))
                    .map(property(BidModifierRegionalAdjustment.REGION_ID, GEO_MULTIPLIER_VALUES.REGION_ID))
                    .map(integerProperty(BidModifierRegionalAdjustment.PERCENT, GEO_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(booleanProperty(BidModifierRegionalAdjustment.HIDDEN, GEO_MULTIPLIER_VALUES.IS_HIDDEN))
                    .map(property(BidModifierRegionalAdjustment.LAST_CHANGE, GEO_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierRetargetingAdjustment>
            RETARGETING_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierRetargetingAdjustment::new)
                    .map(property(BidModifierRetargetingAdjustment.ID,
                            RETARGETING_MULTIPLIER_VALUES.RETARGETING_MULTIPLIER_VALUE_ID))
                    .map(property(BidModifierRetargetingAdjustment.RETARGETING_CONDITION_ID,
                            RETARGETING_MULTIPLIER_VALUES.RET_COND_ID))
                    .map(integerProperty(BidModifierRetargetingAdjustment.PERCENT,
                            RETARGETING_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierRetargetingAdjustment.LAST_CHANGE,
                            RETARGETING_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierRetargetingFilterAdjustment>
            RETARGETING_FILTER_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierRetargetingFilterAdjustment::new)
                    .map(property(BidModifierRetargetingAdjustment.ID,
                            RETARGETING_MULTIPLIER_VALUES.RETARGETING_MULTIPLIER_VALUE_ID))
                    .map(property(BidModifierRetargetingAdjustment.RETARGETING_CONDITION_ID,
                            RETARGETING_MULTIPLIER_VALUES.RET_COND_ID))
                    .map(integerProperty(BidModifierRetargetingAdjustment.PERCENT,
                            RETARGETING_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierRetargetingAdjustment.LAST_CHANGE,
                            RETARGETING_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierABSegmentAdjustment> AB_SEGMENT_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierABSegmentAdjustment::new)
                    .map(property(BidModifierABSegmentAdjustment.ID,
                            AB_SEGMENT_MULTIPLIER_VALUES.AB_SEGMENT_MULTIPLIER_VALUE_ID))
                    .map(property(BidModifierABSegmentAdjustment.AB_SEGMENT_RETARGETING_CONDITION_ID,
                            AB_SEGMENT_MULTIPLIER_VALUES.AB_SEGMENT_RET_COND_ID))
                    .map(integerProperty(BidModifierABSegmentAdjustment.PERCENT,
                            AB_SEGMENT_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierABSegmentAdjustment.LAST_CHANGE, AB_SEGMENT_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierBannerTypeAdjustment> BANNER_TYPE_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierBannerTypeAdjustment::new)
                    .map(property(BidModifierBannerTypeAdjustment.ID,
                            BANNER_TYPE_MULTIPLIER_VALUES.BANNER_TYPE_MULTIPLIER_VALUE_ID))
                    .map(convertibleProperty(BidModifierBannerTypeAdjustment.BANNER_TYPE,
                            BANNER_TYPE_MULTIPLIER_VALUES.BANNER_TYPE,
                            BannerType::fromSource, BannerType::toSource))
                    .map(integerProperty(BidModifierBannerTypeAdjustment.PERCENT,
                            BANNER_TYPE_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierBannerTypeAdjustment.LAST_CHANGE,
                            BANNER_TYPE_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierInventoryAdjustment> INVENTORY_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierInventoryAdjustment::new)
                    .map(property(BidModifierInventoryAdjustment.ID,
                            INVENTORY_MULTIPLIER_VALUES.INVENTORY_MULTIPLIER_VALUE_ID))
                    .map(convertibleProperty(BidModifierInventoryAdjustment.INVENTORY_TYPE,
                            INVENTORY_MULTIPLIER_VALUES.INVENTORY_TYPE,
                            InventoryType::fromSource, InventoryType::toSource))
                    .map(integerProperty(BidModifierInventoryAdjustment.PERCENT,
                            INVENTORY_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierInventoryAdjustment.LAST_CHANGE, INVENTORY_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final JooqMapperWithSupplier<BidModifierTrafaretPositionAdjustment> TRAFARET_POSITION_ADJUSTMENT_MAPPER =
            JooqMapperWithSupplierBuilder.builder(BidModifierTrafaretPositionAdjustment::new)
                    .map(property(BidModifierTrafaretPositionAdjustment.ID,
                            TRAFARET_POSITION_MULTIPLIER_VALUES.TRAFARET_POSITION_MULTIPLIER_VALUE_ID))
                    .map(convertibleProperty(BidModifierTrafaretPositionAdjustment.TRAFARET_POSITION,
                            TRAFARET_POSITION_MULTIPLIER_VALUES.TRAFARET_POSITION,
                            TrafaretPosition::fromSource, TrafaretPosition::toSource))
                    .map(integerProperty(BidModifierTrafaretPositionAdjustment.PERCENT,
                            TRAFARET_POSITION_MULTIPLIER_VALUES.MULTIPLIER_PCT))
                    .map(property(BidModifierTrafaretPositionAdjustment.LAST_CHANGE,
                            TRAFARET_POSITION_MULTIPLIER_VALUES.LAST_CHANGE))
                    .build();

    public static final FieldMapper<RetargetingGoalsRecord, AbstractBidModifierRetargetingAdjustment, Long, Boolean>
            RETARGETING_IS_ACCESSIBLE_FIELD_MAPPER =
            convertibleField(RETARGETING_GOALS.IS_ACCESSIBLE, AbstractBidModifierRetargetingAdjustment.ACCESSIBLE,
                    AbstractBidModifierRetargetingAdjustment.class)
                    .convertFromDbBy(RepositoryUtils::booleanFromLong)
                    .disableWritingToDb();

    public static final FieldMapper<RetargetingGoalsRecord, BidModifierABSegmentAdjustment, Long, Boolean>
            AB_SEGMENT_IS_ACCESSIBLE_FIELD_MAPPER =
            convertibleField(RETARGETING_GOALS.IS_ACCESSIBLE, BidModifierABSegmentAdjustment.ACCESSIBLE,
                    BidModifierABSegmentAdjustment.class)
                    .convertFromDbBy(RepositoryUtils::booleanFromLong)
                    .disableWritingToDb();

    static {
        ALL_BIDMODIFIER_FIELDS =
                StreamEx.of(BASE_MAPPER, MOBILE_MAPPER_WITH_OS_TYPE, MOBILE_MAPPER_WITHOUT_OS_TYPE, VIDEO_MAPPER,
                        TABLET_MAPPER_WITHOUT_OS_TYPE, TABLET_MAPPER_WITH_OS_TYPE,
                        AB_SEGMENT_MAPPER, PERFORMANCE_TGO_MAPPER, DESKTOP_MAPPER, DESKTOP_ONLY_MAPPER,
                        BANNER_TYPE_MAPPER, SMARTTV_MAPPER, INVENTORY_MAPPER, TRAFARET_POSITION_MAPPER)
                        .map(JooqMapper::getFieldsToRead).flatMap(Collection::stream).distinct().toList();

        DEMOGRAPHY_ADJUSTMENT_FIELDS = Stream.concat(
                DEMOGRAPHY_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(DEMOGRAPHY_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());

        WEATHER_ADJUSTMENT_FIELDS = Stream.concat(
                WEATHER_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(WEATHER_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());

        REGIONAL_ADJUSTMENT_FIELDS = Stream.concat(
                REGIONAL_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(GEO_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());

        RETARGETING_ADJUSTMENT_FIELDS = Stream.concat(
                RETARGETING_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(RETARGETING_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());

        AB_SEGMENT_ADJUSTMENT_FIELDS = Stream.concat(
                AB_SEGMENT_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(AB_SEGMENT_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());

        BANNER_TYPE_ADJUSTMENT_FIELDS = Stream.concat(
                BANNER_TYPE_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(BANNER_TYPE_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());

        INVENTORY_ADJUSTMENT_FIELDS = Stream.concat(
                INVENTORY_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(INVENTORY_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());

        EXPRESSION_ADJUSTMENT_FIELDS = Stream.concat(
                EXPRESSION_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(EXPRESSION_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());

        TRAFARET_POSITION_ADJUSTMENT_FIELDS = Stream.concat(
                TRAFARET_POSITION_ADJUSTMENT_MAPPER.getFieldsToRead().stream(),
                Stream.of(TRAFARET_POSITION_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID)).collect(toList());
    }

    /**
     * Вычисляет хеш по комбинации campaignId, adGroupId и типа корректировки
     * Необходимо для обеспечения гарантий уникальности в БД (из-за того, что adGroup может быть равен NULL)
     */
    public static BigInteger computeSyntheticKeyHash(BidModifierType multiplierType, long campaignId,
                                                     @Nullable Long adGroupId) {
        String typeKey = ifNotNull(BidModifierType.toSource(multiplierType), HierarchicalMultipliersType::getLiteral);
        Preconditions.checkNotNull(typeKey, "Unknown type");
        return HashingUtils.getMd5HalfHashUtf8(String.format("%s:%d:%s",
                typeKey, campaignId, adGroupId != null ? Long.toString(adGroupId) : "campaign"));
    }
}
