package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jooq.DSLContext;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierAdjustment;
import ru.yandex.direct.core.entity.bidmodifiers.container.AddedBidModifierInfo;
import ru.yandex.direct.core.entity.bidmodifiers.container.BidModifierKey;
import ru.yandex.direct.core.entity.container.CampaignIdAndAdGroupIdPair;
import ru.yandex.direct.dbutil.model.ClientId;

public interface BidModifierMultipleValuesTypeSupport<TModifier extends BidModifier,
        TAdjustment extends BidModifierAdjustment> extends BidModifierTypeSupport<TModifier, TAdjustment> {
    /**
     * Позволяет задать список adjustments указанному набору корректировок.
     */
    void setAdjustments(TModifier modifier, List<TAdjustment> adjustments);

    /**
     * Вытаскивает список adjustments из набора корректировок.
     */
    List<TAdjustment> getAdjustments(TModifier modifier);

    /**
     * Добавляет наборы корректировок или корректировки к уже имеющимся наборам.
     *
     * @param txContext               Контекст транзакции
     * @param modifiers               Новые корректировки/наборы корректировок
     * @param lockedExistingModifiers Взятые с updLock имеющиеся наборы корректировок
     * @param clientId                id клиента
     * @param operatorUid             id оператора
     * @return Возвращает инфо о добавленных идентификаторах
     */
    Map<BidModifierKey, AddedBidModifierInfo> add(DSLContext txContext, List<TModifier> modifiers,
                                                  Map<BidModifierKey, TModifier> lockedExistingModifiers, ClientId clientId, long operatorUid);

    /**
     * Сохраняет указанные корректировки в БД в рамках контекста транзакции txContext.
     * Корректировки, которые уже присутствуют в БД, будут удалены, если в новых наборах их не окажется
     * (в отличие от поведения метода {@link #add})
     */
    Set<CampaignIdAndAdGroupIdPair> addOrReplace(DSLContext txContext, List<TModifier> newModifiers,
                                                 Map<BidModifierKey, TModifier> lockedExistingModifiers, ClientId clientId, long operatorUid);

    /**
     * Заполняет корректировки в переданных изначально пустых наборах.
     *
     * @param dslContext   Контекст транзакции
     * @param bidModifiers Наборы без корректировок
     * @param updLock      Брать ли блокировку updLock
     */
    void fillAdjustments(DSLContext dslContext, Collection<TModifier> bidModifiers, boolean updLock);

    /**
     * Загружает записи из дочерних таблиц по id и группирует по hierarchical_multiplier_id
     */
    Map<Long, List<TAdjustment>> getAdjustmentsByIds(DSLContext dslContext, Collection<Long> ids);

    @Override
    default boolean isMultiValues() {
        return true;
    }
}
