package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jooq.DSLContext;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierAdjustment;
import ru.yandex.direct.core.entity.bidmodifiers.container.AddedBidModifierInfo;
import ru.yandex.direct.core.entity.bidmodifiers.container.BidModifierKey;
import ru.yandex.direct.core.entity.container.CampaignIdAndAdGroupIdPair;

/**
 * Интерфейс для реализации типоспецифичной логики репозитория корректировок.
 *
 * @param <B> тип корректировки
 */
public interface BidModifierSingleValueTypeSupport<B extends BidModifier,
        TAdjustment extends BidModifierAdjustment> extends BidModifierTypeSupport<B, TAdjustment> {
    /**
     * Добавляет указанные корректировки в БД в рамках контекста транзакции txContext.
     */
    Map<BidModifierKey, AddedBidModifierInfo> add(DSLContext txContext, List<B> modifiers, long operatorUid);

    Set<CampaignIdAndAdGroupIdPair> addOrReplace(DSLContext txContext, List<B> modifiers,
                                                 Map<BidModifierKey, BidModifier> lockedExistingModifiers,
                                                 long operatorUid);

    @Override
    default boolean isMultiValues() {
        return false;
    }
}
