package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.multivalue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierContentDuration;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierContentDurationAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Корректировка по длительности контента
 */
@Component
@ParametersAreNonnullByDefault
public class BidModifierContentDurationTypeSupport
        extends AbstractBidModifierExpressionTypeSupport<BidModifierContentDuration, BidModifierContentDurationAdjustment> {
    protected BidModifierContentDurationTypeSupport(ShardHelper shardHelper, LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public Class<BidModifierContentDuration> getBidModifierClass() {
        return BidModifierContentDuration.class;
    }

    @Override
    public Class<BidModifierContentDurationAdjustment> getAdjustmentClass() {
        return BidModifierContentDurationAdjustment.class;
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.EXPRESS_CONTENT_DURATION_MULTIPLIER;
    }
}
