package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.multivalue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPrismaIncomeGrade;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPrismaIncomeGradeAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Component
@ParametersAreNonnullByDefault
public class BidModifierPrismaIncomeGradeTypeSupport
        extends AbstractBidModifierExpressionTypeSupport<BidModifierPrismaIncomeGrade,
        BidModifierPrismaIncomeGradeAdjustment> {

    protected BidModifierPrismaIncomeGradeTypeSupport(ShardHelper shardHelper,
                                                      LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.PRISMA_INCOME_GRADE_MULTIPLIER;
    }

    @Override
    public Class<BidModifierPrismaIncomeGradeAdjustment> getAdjustmentClass() {
        return BidModifierPrismaIncomeGradeAdjustment.class;
    }

    @Override
    public Class<BidModifierPrismaIncomeGrade> getBidModifierClass() {
        return BidModifierPrismaIncomeGrade.class;
    }
}
