package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.multivalue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingFilter;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingFilterAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;

import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.RETARGETING_FILTER_ADJUSTMENT_MAPPER;
import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.RETARGETING_FILTER_MAPPER;

@Component
@ParametersAreNonnullByDefault
public class BidModifierRetargetingFilterTypeSupport extends AbstractBidModifierRetargetingTypeSupport<BidModifierRetargetingFilter, BidModifierRetargetingFilterAdjustment> {

    @Autowired
    protected BidModifierRetargetingFilterTypeSupport(ShardHelper shardHelper,
                                                      LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    protected JooqMapperWithSupplier<BidModifierRetargetingFilterAdjustment> getAdjustmentMapper() {
        return RETARGETING_FILTER_ADJUSTMENT_MAPPER;
    }

    @Override
    public Class<BidModifierRetargetingFilter> getBidModifierClass() {
        return BidModifierRetargetingFilter.class;
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.RETARGETING_FILTER;
    }

    @Override
    public BidModifierRetargetingFilter createEmptyBidModifierFromRecord(Record record) {
        return RETARGETING_FILTER_MAPPER.fromDb(record);
    }

    @Override
    public Class<BidModifierRetargetingFilterAdjustment> getAdjustmentClass() {
        return BidModifierRetargetingFilterAdjustment.class;
    }
}
