package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.multivalue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargeting;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;

import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.RETARGETING_ADJUSTMENT_MAPPER;
import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.RETARGETING_MAPPER;

@Component
@ParametersAreNonnullByDefault
public class BidModifierRetargetingTypeSupport extends AbstractBidModifierRetargetingTypeSupport<
        BidModifierRetargeting, BidModifierRetargetingAdjustment> {
    @Autowired
    protected BidModifierRetargetingTypeSupport(ShardHelper shardHelper,
                                                LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.RETARGETING_MULTIPLIER;
    }

    @Override
    public Class<BidModifierRetargeting> getBidModifierClass() {
        return BidModifierRetargeting.class;
    }

    @Override
    public BidModifierRetargeting createEmptyBidModifierFromRecord(Record record) {
        return RETARGETING_MAPPER.fromDb(record);
    }

    @Override
    public Class<BidModifierRetargetingAdjustment> getAdjustmentClass() {
        return BidModifierRetargetingAdjustment.class;
    }

    @Override
    protected JooqMapperWithSupplier<BidModifierRetargetingAdjustment> getAdjustmentMapper() {
        return RETARGETING_ADJUSTMENT_MAPPER;
    }
}
