package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.multivalue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTraffic;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTrafficAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Корректировка по автомобильным пробкам.
 */
@Component
@ParametersAreNonnullByDefault
public class BidModifierTrafficTypeSupport
        extends AbstractBidModifierExpressionTypeSupport<BidModifierTraffic, BidModifierTrafficAdjustment> {
    protected BidModifierTrafficTypeSupport(ShardHelper shardHelper, LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public Class<BidModifierTraffic> getBidModifierClass() {
        return BidModifierTraffic.class;
    }

    @Override
    public Class<BidModifierTrafficAdjustment> getAdjustmentClass() {
        return BidModifierTrafficAdjustment.class;
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.EXPRESS_TRAFFIC_MULTIPLIER;
    }
}
