package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.singlevalue;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopOnly;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopOnlyAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.DESKTOP_ONLY_MAPPER;
import static ru.yandex.direct.dbschema.ppc.Tables.HIERARCHICAL_MULTIPLIERS;

@Component
@ParametersAreNonnullByDefault
public class BidModifierDesktopOnlySingleValueTypeSupport
        extends AbstractBidModifierSingleValueTypeSupport<BidModifierDesktopOnly, BidModifierDesktopOnlyAdjustment> {

    @Autowired
    public BidModifierDesktopOnlySingleValueTypeSupport(ShardHelper shardHelper,
                                                        LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.DESKTOP_ONLY_MULTIPLIER;
    }

    @Override
    public Class<BidModifierDesktopOnly> getBidModifierClass() {
        return BidModifierDesktopOnly.class;
    }

    @Override
    public Class<BidModifierDesktopOnlyAdjustment> getAdjustmentClass() {
        return BidModifierDesktopOnlyAdjustment.class;
    }

    @Override
    public boolean areEqual(BidModifierDesktopOnly a, BidModifierDesktopOnly b) {
        return Objects.equals(a, b);
    }

    @Override
    public List<BidModifierDesktopOnlyAdjustment> getAdjustments(BidModifierDesktopOnly modifier) {
        return singletonList(modifier.getDesktopOnlyAdjustment());
    }

    @Override
    public BidModifierDesktopOnly createEmptyBidModifierFromRecord(Record record) {
        return DESKTOP_ONLY_MAPPER.fromDb(record);
    }

    @Override
    protected int extractPercent(BidModifierDesktopOnly modifier) {
        return modifier.getDesktopOnlyAdjustment().getPercent();
    }

    @Override
    protected void insertBidModifiers(List<BidModifierDesktopOnly> bidModifiers, DSLContext dslContext) {
        new InsertHelper<>(dslContext, HIERARCHICAL_MULTIPLIERS).addAll(DESKTOP_ONLY_MAPPER, bidModifiers).execute();
    }
}
