package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.singlevalue;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktop;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.DESKTOP_MAPPER;
import static ru.yandex.direct.dbschema.ppc.tables.HierarchicalMultipliers.HIERARCHICAL_MULTIPLIERS;

@Component
@ParametersAreNonnullByDefault
public class BidModifierDesktopSingleValueTypeSupport extends AbstractBidModifierSingleValueTypeSupport<BidModifierDesktop, BidModifierDesktopAdjustment> {
    @Autowired
    public BidModifierDesktopSingleValueTypeSupport(ShardHelper shardHelper,
                                                    LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.DESKTOP_MULTIPLIER;
    }

    @Override
    public Class<BidModifierDesktop> getBidModifierClass() {
        return BidModifierDesktop.class;
    }

    @Override
    public Class<BidModifierDesktopAdjustment> getAdjustmentClass() {
        return BidModifierDesktopAdjustment.class;
    }

    @Override
    public boolean areEqual(BidModifierDesktop a, BidModifierDesktop b) {
        return Objects.equals(a, b);
    }

    @Override
    public List<BidModifierDesktopAdjustment> getAdjustments(BidModifierDesktop modifier) {
        return singletonList(modifier.getDesktopAdjustment());
    }

    @Override
    public BidModifierDesktop createEmptyBidModifierFromRecord(Record record) {
        return DESKTOP_MAPPER.fromDb(record);
    }

    @Override
    protected int extractPercent(BidModifierDesktop modifier) {
        return modifier.getDesktopAdjustment().getPercent();
    }

    @Override
    protected void insertBidModifiers(List<BidModifierDesktop> bidModifiers, DSLContext dslContext) {
        new InsertHelper<>(dslContext, HIERARCHICAL_MULTIPLIERS).addAll(DESKTOP_MAPPER, bidModifiers).execute();
    }
}
