package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.singlevalue;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgoAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.PERFORMANCE_TGO_MAPPER;
import static ru.yandex.direct.dbschema.ppc.tables.HierarchicalMultipliers.HIERARCHICAL_MULTIPLIERS;

@Component
@ParametersAreNonnullByDefault
public class BidModifierPerformanceTgoSingleValueTypeSupport extends AbstractBidModifierSingleValueTypeSupport
        <BidModifierPerformanceTgo, BidModifierPerformanceTgoAdjustment> {
    public BidModifierPerformanceTgoSingleValueTypeSupport(ShardHelper shardHelper,
                                                           LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.PERFORMANCE_TGO_MULTIPLIER;
    }

    @Override
    public Class<BidModifierPerformanceTgo> getBidModifierClass() {
        return BidModifierPerformanceTgo.class;
    }

    @Override
    public Class<BidModifierPerformanceTgoAdjustment> getAdjustmentClass() {
        return BidModifierPerformanceTgoAdjustment.class;
    }

    @Override
    public List<BidModifierPerformanceTgoAdjustment> getAdjustments(BidModifierPerformanceTgo modifier) {
        return singletonList(modifier.getPerformanceTgoAdjustment());
    }

    @Override
    protected int extractPercent(BidModifierPerformanceTgo modifier) {
        return modifier.getPerformanceTgoAdjustment().getPercent();
    }

    @Override
    protected void insertBidModifiers(List<BidModifierPerformanceTgo> bidModifiers, DSLContext dslContext) {
        new InsertHelper<>(dslContext, HIERARCHICAL_MULTIPLIERS).addAll(PERFORMANCE_TGO_MAPPER, bidModifiers).execute();
    }

    @Override
    public BidModifierPerformanceTgo createEmptyBidModifierFromRecord(Record record) {
        return PERFORMANCE_TGO_MAPPER.fromDb(record);
    }

    @Override
    public boolean areEqual(BidModifierPerformanceTgo a, BidModifierPerformanceTgo b) {
        return Objects.equals(a, b);
    }
}
