package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.singlevalue;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierSmartTV;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierSmartTVAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.SMARTTV_MAPPER;
import static ru.yandex.direct.dbschema.ppc.tables.HierarchicalMultipliers.HIERARCHICAL_MULTIPLIERS;

@Component
@ParametersAreNonnullByDefault
public class BidModifierSmartTVSingleValueTypeSupport extends AbstractBidModifierSingleValueTypeSupport<BidModifierSmartTV, BidModifierSmartTVAdjustment> {
    @Autowired
    public BidModifierSmartTVSingleValueTypeSupport(ShardHelper shardHelper,
                                                    LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.SMARTTV_MULTIPLIER;
    }

    @Override
    public Class<BidModifierSmartTV> getBidModifierClass() {
        return BidModifierSmartTV.class;
    }

    @Override
    public Class<BidModifierSmartTVAdjustment> getAdjustmentClass() {
        return BidModifierSmartTVAdjustment.class;
    }

    @Override
    public boolean areEqual(BidModifierSmartTV a, BidModifierSmartTV b) {
        return Objects.equals(a, b);
    }

    @Override
    public List<BidModifierSmartTVAdjustment> getAdjustments(BidModifierSmartTV modifier) {
        return singletonList(modifier.getSmartTVAdjustment());
    }

    @Override
    public BidModifierSmartTV createEmptyBidModifierFromRecord(Record record) {
        return SMARTTV_MAPPER.fromDb(record);
    }

    @Override
    protected int extractPercent(BidModifierSmartTV modifier) {
        return modifier.getSmartTVAdjustment().getPercent();
    }

    @Override
    protected void insertBidModifiers(List<BidModifierSmartTV> bidModifiers, DSLContext dslContext) {
        new InsertHelper<>(dslContext, HIERARCHICAL_MULTIPLIERS).addAll(SMARTTV_MAPPER, bidModifiers).execute();
    }
}
