package ru.yandex.direct.core.entity.bidmodifiers.repository.typesupport.singlevalue;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.service.LogBidModifiersService;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideoAdjustment;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.VIDEO_MAPPER;
import static ru.yandex.direct.dbschema.ppc.tables.HierarchicalMultipliers.HIERARCHICAL_MULTIPLIERS;

@Component
@ParametersAreNonnullByDefault
public class BidModifierVideoSingleValueTypeSupport extends AbstractBidModifierSingleValueTypeSupport<BidModifierVideo, BidModifierVideoAdjustment> {
    @Autowired
    public BidModifierVideoSingleValueTypeSupport(ShardHelper shardHelper,
                                                  LogBidModifiersService logBidModifiersService) {
        super(shardHelper, logBidModifiersService);
    }

    @Override
    public BidModifierType getType() {
        return BidModifierType.VIDEO_MULTIPLIER;
    }

    @Override
    public Class<BidModifierVideo> getBidModifierClass() {
        return BidModifierVideo.class;
    }

    @Override
    public Class<BidModifierVideoAdjustment> getAdjustmentClass() {
        return BidModifierVideoAdjustment.class;
    }

    @Override
    public boolean areEqual(BidModifierVideo a, BidModifierVideo b) {
        return Objects.equals(a, b);
    }

    @Override
    public List<BidModifierVideoAdjustment> getAdjustments(BidModifierVideo modifier) {
        return singletonList(modifier.getVideoAdjustment());
    }

    @Override
    public BidModifierVideo createEmptyBidModifierFromRecord(Record record) {
        return VIDEO_MAPPER.fromDb(record);
    }

    @Override
    protected int extractPercent(BidModifierVideo modifier) {
        return modifier.getVideoAdjustment().getPercent();
    }

    @Override
    protected void insertBidModifiers(List<BidModifierVideo> bidModifiers, DSLContext dslContext) {
        new InsertHelper<>(dslContext, HIERARCHICAL_MULTIPLIERS).addAll(VIDEO_MAPPER, bidModifiers).execute();
    }
}
