package ru.yandex.direct.core.entity.bidmodifiers.service;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierContentDuration;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierContentDurationAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierExpression;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierExpressionAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPrismaIncomeGrade;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPrismaIncomeGradeAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTraffic;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTrafficAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Умеет производить объекты универсальных корректировок по их типу.
 */
public class BidModifierExpressionFactory {
    private static final Map<BidModifierType, Class<? extends BidModifierExpression>> BID_MODIFIER_CLASSES =
            Map.of(
                    BidModifierType.EXPRESS_TRAFFIC_MULTIPLIER, BidModifierTraffic.class,
                    BidModifierType.EXPRESS_CONTENT_DURATION_MULTIPLIER, BidModifierContentDuration.class,
                    BidModifierType.PRISMA_INCOME_GRADE_MULTIPLIER, BidModifierPrismaIncomeGrade.class
            );
    private static final Map<BidModifierType, Class<? extends BidModifierExpressionAdjustment>> ADJUSTMENT_CLASSES =
            Map.of(
                    BidModifierType.EXPRESS_TRAFFIC_MULTIPLIER, BidModifierTrafficAdjustment.class,
                    BidModifierType.EXPRESS_CONTENT_DURATION_MULTIPLIER, BidModifierContentDurationAdjustment.class,
                    BidModifierType.PRISMA_INCOME_GRADE_MULTIPLIER, BidModifierPrismaIncomeGradeAdjustment.class
            );

    private BidModifierExpressionFactory() {
    }

    public static boolean notExpressionBidModifierType(BidModifierType type) {
        return !BID_MODIFIER_CLASSES.containsKey(type);
    }

    public static BidModifierExpression createBidModifierByType(BidModifierType bidModifierType) {
        var bidModExpressClass = BID_MODIFIER_CLASSES.get(bidModifierType);
        checkNotNull(bidModExpressClass);
        try {
            return bidModExpressClass.getDeclaredConstructor().newInstance();
        } catch (NoSuchMethodException | InstantiationException | IllegalAccessException |
                InvocationTargetException ex
        ) {
            throw new RuntimeException(ex);
        }
    }

    public static BidModifierExpressionAdjustment createBidModifierAdjustmentByType(BidModifierType bidModifierType) {
        var adjustmentExpressClass = ADJUSTMENT_CLASSES.get(bidModifierType);
        checkNotNull(adjustmentExpressClass);
        try {
            return adjustmentExpressClass.getDeclaredConstructor().newInstance();
        } catch (NoSuchMethodException | InstantiationException | IllegalAccessException |
                InvocationTargetException ex
        ) {
            throw new RuntimeException(ex);
        }
    }
}
