package ru.yandex.direct.core.entity.bidmodifiers.service;

/**
 * Набор настроек, специфичных для разных типов корректировок и зависящих от типа кампании.
 * Например, для кампании типа MOBILE_CONTENT мобильные корректировки недоступны.
 */
public class BidModifierLimits {
    public final int percentMin;
    public final int percentMax;
    /**
     * Указывает, доступна ли вообще корректировка этого типа для рассматриваемого типа кампании.
     */
    public final boolean enabled;
    public final Integer maxConditions;

    public BidModifierLimits(int percentMin, int percentMax, boolean enabled, Integer maxConditions) {
        this.percentMin = percentMin;
        this.percentMax = percentMax;
        this.enabled = enabled;
        this.maxConditions = maxConditions;
    }

    public static class Builder {
        private Integer percentMin;
        private Integer percentMax;
        private Boolean enabled;
        private Integer maxConditions;

        Builder() {
        }

        Builder(BidModifierLimits object) {
            this.percentMin = object.percentMin;
            this.percentMax = object.percentMax;
            this.enabled = object.enabled;
            this.maxConditions = object.maxConditions;
        }

        Builder withPercentMin(int percentMin) {
            this.percentMin = percentMin;
            return this;
        }

        Builder withPercentMax(int percentMax) {
            this.percentMax = percentMax;
            return this;
        }

        Builder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        Boolean getEnabled() {
            return enabled;
        }

        Builder withMaxConditions(Integer maxConditions) {
            this.maxConditions = maxConditions;
            return this;
        }

        BidModifierLimits build() {
            if (this.percentMin == null) {
                throw new IllegalStateException("Required field percentMin is not initialized");
            }
            if (this.percentMax == null) {
                throw new IllegalStateException("Required field percentMax is not initialized");
            }
            if (this.enabled == null) {
                throw new IllegalStateException("Required field enabled is not initialized");
            }
            return new BidModifierLimits(percentMin, percentMax, enabled, maxConditions);
        }
    }
}
