package ru.yandex.direct.core.entity.bidmodifiers.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;

public class CachingFeaturesProvider implements FeaturesProvider {
    private final FeatureService featureService;
    private final Map<Pair<ClientId, FeatureName>, Boolean> cache = new ConcurrentHashMap<>();

    public CachingFeaturesProvider(FeatureService featureService) {
        this.featureService = featureService;
    }

    public boolean isEnabledForClientId(ClientId clientId, FeatureName featureName) {
        Pair<ClientId, FeatureName> key = Pair.of(clientId, featureName);
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        boolean result = featureService.isEnabledForClientId(clientId, featureName);
        cache.put(key, result);
        return result;
    }
}
