package ru.yandex.direct.core.entity.bidmodifiers.validation;

import java.util.List;

import ru.yandex.direct.core.entity.bidmodifiers.Constants;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class BidModifiersDefectIds {
    public enum GeneralDefects implements DefectId<Void> {
        /**
         * Корректировки по региону показа не поддерживаются на уровне группы объявлений
         */
        GEO_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS,
        /**
         * Условие подбора аудитории не может присутствовать в наборе более одного раза
         */
        DUPLICATE_RETARGETING_CONDITION,
        /**
         * Набор корректировок не может присутствовать в запросе более одного раза
         */
        DUPLICATE_ADJUSTMENT,
        /**
         * Корректировка не может присутствовать в запросе более одного раза
         */
        DUPLICATE_SINGLE_ADJUSTMENT,
        /**
         * Обязательно должен быть указан пол или возраст
         */
        REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER,
        /**
         * Обязательно должно быть указано хотя бы одно выражение
         */
        REQUIRED_AT_LEAST_ONE_EXPRESSION,
        /**
         * Должны быть указаны обязательные поля
         */
        REQUIRED_EXPRESSION_FIELDS,
        /**
         * Указанное значение не соответствует параметру
         */
        INVALID_PARAMETER_VALUE,
        /**
         * Указанный параметр не поддерживается
         */
        INVALID_PARAMETER,
        /**
         * Пересекаются условия корректировок в наборе
         */
        DEMOGRAPHICS_CONDITIONS_INTERSECTION,
        /**
         * Значение percent должно быть положительным
         */
        INVALID_PERCENT_SHOULD_BE_POSITIVE,
        /**
         * Тип корректировок не поддерживается для этого типа кампании
         */
        NOT_SUPPORTED_MULTIPLIER,
        /**
         * Пересекаются регионы корректировок в наборе
         */
        GEO_REGIONS_INTERSECTION,
        /**
         * Пересекаются трафареты корректировок в наборе
         */
        TRAFARET_POSITIONS_INTERSECTION,
        /**
         * Объект с указанными характеристиками уже существует
         */
        SINGLE_VALUE_MODIFIER_ALREADY_EXISTS,
        /**
         * Не удалось применить изменения: во время сохранения набор корректировок был изменён
         */
        CONFLICT_APPLYING_CHANGES,
        /**
         * Корректировка не найдена
         */
        ADJUSTMENT_NOT_FOUND,
        /**
         * Набор корректировок не найден
         */
        ADJUSTMENT_SET_NOT_FOUND,
        /**
         * Пересекаются корректировки сегментов в наборе
         */
        AB_SEGMENT_BID_MODIFIERS_INTERSECTION,
        /**
         * Корректировки по региону показа не поддерживаются на уровне группы объявлений
         */
        AB_SEGMENT_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS,
        /**
         * Тип условий нацеливания нельзя использовать в корректировках
         */
        UNSUPPORTED_RETARGETING_TYPE,
        /**
         * Нельзя устанавливать корректировку -100% на все устройства
         */
        DEVICE_BID_MODIFIERS_ALL_ZEROS,
        /**
         * Тип операционной системы нельзя указывать в корректировках ставок для данного типа кампании или группы
         */
        SETTING_OS_TYPE_NOT_ALLOWED,
        /**
         * Некорректно сформировано элементарное выражение в КНФ-формуле для expression-корректировки
         */
        INVALID_EXPRESSION_LITERAL,
        /**
         * Формула принимает одно и то же значение (true или false) для любых комбинаций значений параметров.
         * Это означает, что корректировка либо применяется всегда, либо никогда, то есть будет константной.
         * Такие корректировки мы считаем некорректными.
         */
        EXPRESSION_ADJUSTMENT_IS_CONSTANT_FOR_ANY_VALUES,
        /**
         * Условия в expression-корректировках пересекаются
         * (существует комбинация значений параметров, для которой срабатывает более 1 корректировки из набора)
         */
        EXPRESSION_CONDITIONS_INTERSECTION,
        /**
         * В модели ComplexBidModifier обнаружены повторы в списке универсальных корректировок
         * (набор корректировок для одного из типов указан дважды)
         */
        ONE_TYPE_USED_TWICE_IN_COMPLEX_MODIFIER,
    }

    public enum Number implements DefectId<NumberDefectParams> {
        TOO_MANY_EXPRESSION_CONDITIONS,
        TOO_MANY_WEATHER_CONDITIONS,
        TOO_MANY_DEMOGRAPHY_CONDITIONS,
        TOO_MANY_RETARGETING_CONDITIONS,
        TOO_MANY_INVENTORY_CONDITIONS,
        TOO_MANY_TRAFARET_POSITION_CONDITIONS
    }

    public enum IdParametrized implements DefectId<ModelIdDefectParams> {
        AB_SEGMENT_NOT_FOUND,
        AB_SEGMENT_SECTION_NOT_FOUND,
    }

    public enum RegionIdsDefects implements DefectId<String> {
        /**
         * Заданы несуществующие регионы
         */
        NONEXISTENT_REGION_IDS,
    }

    // TODO : перенести их в АПИ, они ведь про апишные ограничения
    public enum LimitOffsetDefects implements DefectId<Integer> {
        /**
         * Нельзя ссылаться на элементы дальше чем в 120 000 элементов
         * (проверка, которая была в перловой реализации)
         * <br/>
         * см {@link Constants#GET_HARD_LIMIT}
         */
        BID_MODIFIERS_GET_HARD_LIMIT_EXCEEDED,

        /**
         * Разрешено создавать не более 1000 наборов корректировок в одном запросе
         * <br/>
         * см {@link Constants#BID_MODIFIERS_ADD_ITEMS_LIMIT}
         */
        BID_MODIFIERS_ADD_ITEMS_LIMIT_EXCEEDED,

        /**
         * Разрешено изменять не более 1000 коэффициентов в одном запросе
         * <br/>
         * см {@link Constants#BID_MODIFIERS_SET_ITEMS_LIMIT}
         */
        BID_MODIFIERS_SET_ITEMS_LIMIT_EXCEEDED,

        /**
         * Разрешено включать/выключать не более 1000 наборов корректировок в одном запросе
         * <br/>
         * см {@link Constants#BID_MODIFIERS_TOGGLE_ITEMS_LIMIT}
         */
        BID_MODIFIERS_TOGGLE_ITEMS_LIMIT_EXCEEDED,
    }

    public enum ModelDefects implements DefectId<List<String>> {
        REQUIRED_AT_LEAST_ONE_OF_FIELDS,
        POSSIBLE_ONLY_ONE_FIELD,
    }

    public enum IntegerDefects implements DefectId<Integer> {
        /**
         * Температура должна быть больше или равна значению
         */
        TEMP_MUST_BE_GREATER_OR_EQUAL,
        /**
         * Температура должна быть меньше или равна значению
         */
        TEMP_MUST_BE_LESS_OR_EQUAL,
    }
}
