package ru.yandex.direct.core.entity.bidmodifiers.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;

public interface BidModifiersDefectTranslations extends TranslationBundle {
    BidModifiersDefectTranslations INSTANCE = I18NBundle.implement(BidModifiersDefectTranslations.class);

    @MessageFormatStub("Корректировки по региону показа не поддерживаются на уровне группы объявлений")
    Translatable geoBidModifiersNotSupportedOnAdGroupsDetailed();

    @MessageFormatStub("Корректировки по AB-сегментам не поддерживаются на уровне группы объявлений")
    Translatable abSegmentBidModifiersNotSupportedOnAdGroupsDetailed();

    @MessageFormatStub("Условие подбора аудитории не может присутствовать в наборе более одного раза")
    Translatable duplicateRetargetingConditionDetailed();

    @MessageFormatStub("Набор корректировок не может присутствовать в запросе более одного раза")
    Translatable duplicateAdjustmentDetailed();

    @MessageFormatStub("Значение коэффициента должно быть целым положительным числом")
    Translatable invalidPercentNotPositive();

    @MessageFormatStub("Значение коэффициента не может быть меньшe {0}")
    Translatable percentMustBeGreaterThanOrEqualToMin(Identity min);

    @MessageFormatStub("Значение коэффициента не может быть больше {0}")
    Translatable percentMustBeLessThanOrEqualToMax(Identity max);

    @MessageFormatStub("Обязательно должен быть указан пол или возраст")
    Translatable requiredAtLeastOneOfAgeOrGender();

    @MessageFormatStub("Обязательно должно быть хотя бы одно условие корректировки в наборе")
    Translatable requiredAtLeastOneExpression();

    @MessageFormatStub("Должны быть указаны обязательные поля условия корректировки")
    Translatable requiredExpressionFields();

    @MessageFormatStub("Температура не может быть меньшe {0}")
    Translatable tempMustBeGreaterThanOrEqualToMin(Integer min);

    @MessageFormatStub("Температура не может быть больше {0}")
    Translatable tempMustBeLessThanOrEqualToMax(Integer max);

    @MessageFormatStub("Указанное значение не соответствует типу корректировки")
    Translatable invalidParameterValue();

    @MessageFormatStub("Неверный тип корректировки")
    Translatable invalidParameter();

    @MessageFormatStub("Количество корректировок ставок для демографических сегментов аудитории в наборе должно быть от 1 до {0}")
    Translatable tooManyDemographyConditions(Identity max);

    @MessageFormatStub("В наборе должно быть от 1 до {0} корректировок, основанных на условиях подбора аудитории")
    Translatable tooManyRetargetingConditions(Identity max);

    @MessageFormatStub("В наборе должно быть от 1 до {0} корректировок по типу видео")
    Translatable tooManyInventoryConditions(Identity max);

    @MessageFormatStub("В наборе должно быть от 1 до {0} корректировок по погоде")
    Translatable tooManyWeatherConditions(Identity max);

    @MessageFormatStub("В наборе должно быть от 1 до {0} корректировок")
    Translatable tooManyExpressionConditions(Identity max);

    @MessageFormatStub("В наборе должно быть от 1 до {0} корректировок на трафарет")
    Translatable tooManyTrafaretPositionConditions(Identity max);

    @MessageFormatStub("Пересекаются условия корректировок в наборе")
    Translatable demographicsConditionsIntersection();

    @MessageFormatStub("Корректировка данного типа не поддерживается")
    Translatable notSupportedMultiplier();

    @MessageFormatStub("Пересекаются регионы корректировок в наборе")
    Translatable geoRegionsIntersection();

    @MessageFormatStub("Пересекаются корректировки сегментов в наборе")
    Translatable abSegmentsIntersection();

    @MessageFormatStub("Пересекаются трафареты корректировок в наборе")
    Translatable trafaretPositionsIntersection();

    @MessageFormatStub("Сегмент №{0} не существует")
    Translatable abSegmentNotFound(Identity segmentId);

    @MessageFormatStub("Эксперимент №{0} не существует")
    Translatable abSegmentSectionNotFound(Identity sectionId);

    @MessageFormatStub("Разрешено создавать не более {0} наборов корректировок в одном запросе")
    Translatable addItemsLimitExceeded(Identity max);

    @MessageFormatStub("Разрешено включать/отключать не более {0} наборов корректировок в одном запросе")
    Translatable toggleItemsLimitExceeded(Identity max);

    @MessageFormatStub("Корректировка не найдена")
    Translatable notFoundDetailed();

    @MessageFormatStub("Набор корректировок не найден")
    Translatable setNotFoundDetailed();

    @MessageFormatStub("Не удалось применить изменения: во время сохранения набор корректировок был изменён")
    Translatable conflictApplyingChanges();

    @MessageFormatStub("Разрешено изменять не более {0} коэффициентов в одном запросе")
    Translatable setItemsLimitExceeded(Identity max);

    @MessageFormatStub("Корректировка не может присутствовать в запросе более одного раза")
    Translatable duplicateSingleAdjustmentDetailed();

    @MessageFormatStub("Указаны несуществующие регионы: {0}")
    Translatable nonexistentRegionIds(String regionIds);

    @MessageFormatStub("В корректировке ставок не допускается использование условия ретаргетинга и подбора аудитории с типом AUDIENCE")
    Translatable unsupportedRetargetingType();

    @MessageFormatStub("Нельзя устанавливать корректировку ставок -100% на все типы устройств")
    Translatable deviceBidModifiersAllZeros();

    @MessageFormatStub("Тип операционной системы нельзя указывать в корректировках ставок для данного типа кампании или группы")
    Translatable settingOsTypeNotAllowed();

    @MessageFormatStub("Некорректное условие")
    Translatable invalidExpressionLiteral();

    @MessageFormatStub("Условие принимает одно и то же значение для любых значений параметров")
    Translatable expressionAdjustmentIsConstantForAnyValues();

    @MessageFormatStub("Условия в корректировках пересекаются")
    Translatable expressionConditionsIntersection();

    @MessageFormatStub("Обнаружены повторы в списке универсальных корректировок")
    Translatable oneTypeUsedTwiceInComplexModifier();
}
