package ru.yandex.direct.core.entity.bidmodifiers.validation;

import java.util.List;

import ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IdParametrized.AB_SEGMENT_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IdParametrized.AB_SEGMENT_SECTION_NOT_FOUND;

public class BidModifiersDefects {
    public static Defect<List<String>> requiredAtLeastOneOfFields(List<String> fields) {
        return new Defect<>(BidModifiersDefectIds.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS, fields);
    }

    public static Defect<List<String>> possibleOnlyOneField(List<String> fields) {
        return new Defect<>(BidModifiersDefectIds.ModelDefects.POSSIBLE_ONLY_ONE_FIELD, fields);
    }

    public static Defect<Void> requiredAtLeastOneOfAgeOrGender() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER);
    }

    public static Defect<Void> requiredAtLeastOneExpression() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_EXPRESSION);
    }

    public static Defect<Void> requiredExpressionFields() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.REQUIRED_EXPRESSION_FIELDS);
    }

    public static Defect<Void> invalidParameterValue() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.INVALID_PARAMETER_VALUE);
    }

    public static Defect<Void> invalidParameter() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.INVALID_PARAMETER);
    }

    public static Defect<Integer> tempMustBeGreaterThanOrEqualToMin(Integer min) {
        return new Defect<>(
                BidModifiersDefectIds.IntegerDefects.TEMP_MUST_BE_GREATER_OR_EQUAL, min);
    }

    public static Defect<Integer> tempMustBeLessThanOrEqualToMax(Integer max) {
        return new Defect<>(
                BidModifiersDefectIds.IntegerDefects.TEMP_MUST_BE_GREATER_OR_EQUAL, max);
    }

    public static Defect<Void> demographicsConditionsIntersection() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.DEMOGRAPHICS_CONDITIONS_INTERSECTION);
    }

    public static Defect<Void> geoBidModifiersNotSupportedOnAdGroups() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.GEO_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS);
    }

    public static Defect<Void> geoRegionsIntersection() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.GEO_REGIONS_INTERSECTION);
    }

    public static Defect<Void> trafaretPositionsIntersection() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.TRAFARET_POSITIONS_INTERSECTION);
    }

    public static Defect<Void> notSupportedMultiplier() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.NOT_SUPPORTED_MULTIPLIER);
    }

    public static Defect<Void> invalidPercentShouldBePositive() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.INVALID_PERCENT_SHOULD_BE_POSITIVE);
    }

    public static Defect<Void> singleValueModifierAlreadyExists() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.SINGLE_VALUE_MODIFIER_ALREADY_EXISTS);
    }

    public static Defect<Void> duplicateRetargetingCondition() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.DUPLICATE_RETARGETING_CONDITION);
    }

    public static Defect<Void> adjustmentSetNotFound() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_SET_NOT_FOUND);
    }

    public static Defect<Void> retargetingConditionAlreadyExists() {
        return new Defect<>(RetargetingDefectIds.Gen.RETARGETING_CONDITION_ALREADY_EXISTS);
    }

    public static Defect<String> nonexistentRegionIds(String regionIds) {
        return new Defect<>(BidModifiersDefectIds.RegionIdsDefects.NONEXISTENT_REGION_IDS, regionIds);
    }

    public static Defect abSegmentIntersection() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_INTERSECTION);
    }

    public static Defect abSegmentNotFound(long segmentId) {
        return new Defect<>(AB_SEGMENT_NOT_FOUND, new ModelIdDefectParams().withId(segmentId));
    }

    public static Defect abSegmentSectionNotFound(long segmentId) {
        return new Defect<>(AB_SEGMENT_SECTION_NOT_FOUND, new ModelIdDefectParams().withId(segmentId));
    }

    public static Defect<Void> abSegmentBidModifiersNotSupportedOnAdGroups() {
        return new Defect<>(
                BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS);
    }

    public static Defect<Void> unsupportedRetargetingType() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.UNSUPPORTED_RETARGETING_TYPE);
    }

    public static Defect<Void> deviceBidModifiersAllZeros() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.DEVICE_BID_MODIFIERS_ALL_ZEROS);
    }

    public static Defect<Void> settingOsTypeNotAllowed() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.SETTING_OS_TYPE_NOT_ALLOWED);
    }

    public static Defect<Void> invalidExpressionLiteral() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.INVALID_EXPRESSION_LITERAL);
    }

    public static Defect<Void> expressionAdjustmentIsConstantForAnyValues() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.EXPRESSION_ADJUSTMENT_IS_CONSTANT_FOR_ANY_VALUES);
    }

    public static Defect<Void> expressionConditionsIntersection() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.EXPRESSION_CONDITIONS_INTERSECTION);
    }

    public static Defect<Void> oneTypeUsedTwiceInComplexModifier() {
        return new Defect<>(BidModifiersDefectIds.GeneralDefects.ONE_TYPE_USED_TWICE_IN_COMPLEX_MODIFIER);
    }
}
