package ru.yandex.direct.core.entity.bidmodifiers.validation.typesupport;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifiers.service.CachingFeaturesProvider;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgo.PERFORMANCE_TGO_ADJUSTMENT;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefects.singleValueModifierAlreadyExists;

@Component
@ParametersAreNonnullByDefault
public class BidModifierValidationPerformanceTgoTypeSupport implements BidModifierValidationTypeSupport<BidModifierPerformanceTgo> {
    @Override
    public BidModifierType getType() {
        return BidModifierType.PERFORMANCE_TGO_MULTIPLIER;
    }

    @Override
    public ValidationResult<BidModifierPerformanceTgo, Defect> validateAddStep1(
            BidModifierPerformanceTgo modifier, CampaignType campaignType, @Nullable AdGroup adGroupWithType, ClientId clientId,
            CachingFeaturesProvider featuresProvider) {
        ModelItemValidationBuilder<BidModifierPerformanceTgo> vb = ModelItemValidationBuilder.of(modifier);
        vb.item(PERFORMANCE_TGO_ADJUSTMENT).checkBy(adjustment ->
                BidModifierValidationHelper.validateAdjustmentCommon(adjustment, getType(), campaignType,
                        adGroupWithType, clientId, featuresProvider));
        return vb.getResult();
    }

    @Override
    public ValidationResult<BidModifierPerformanceTgo, Defect> validateAddStep2(
            BidModifierPerformanceTgo modifier, BidModifierPerformanceTgo existingModifier, CampaignType campaignType,
            @Nullable AdGroup adGroupWithType, ClientId clientId, CachingFeaturesProvider featuresProvider) {
        ItemValidationBuilder<BidModifierPerformanceTgo, Defect> vb = ItemValidationBuilder.of(modifier);

        // Так как уже существует запись в hierarchicalMultiplier, то добавить туда уже ничего нельзя
        vb.getResult()
                .getOrCreateSubValidationResult(PERFORMANCE_TGO_ADJUSTMENT,
                        modifier.getPerformanceTgoAdjustment())
                .addError(singleValueModifierAlreadyExists());

        return vb.getResult();
    }
}
