package ru.yandex.direct.core.entity.bidmodifiers.validation.typesupport;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo;
import ru.yandex.direct.core.entity.bidmodifiers.service.CachingFeaturesProvider;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo.VIDEO_ADJUSTMENT;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefects.singleValueModifierAlreadyExists;

@Component
@ParametersAreNonnullByDefault
public class BidModifierValidationVideoTypeSupport implements BidModifierValidationTypeSupport<BidModifierVideo> {
    @Override
    public BidModifierType getType() {
        return BidModifierType.VIDEO_MULTIPLIER;
    }

    @Override
    public ValidationResult<BidModifierVideo, Defect> validateAddStep1(BidModifierVideo modifier,
                                                                       CampaignType campaignType,
                                                                       @Nullable AdGroup adGroupWithType,
                                                                       ClientId clientId,
                                                                       CachingFeaturesProvider featuresProvider) {
        ModelItemValidationBuilder<BidModifierVideo> vb = ModelItemValidationBuilder.of(modifier);
        vb.item(VIDEO_ADJUSTMENT).checkBy(adjustment ->
                BidModifierValidationHelper.validateAdjustmentCommon(adjustment, getType(), campaignType,
                        adGroupWithType, clientId, featuresProvider));
        return vb.getResult();
    }

    @Override
    public ValidationResult<BidModifierVideo, Defect> validateAddStep2(BidModifierVideo modifier,
                                                                       BidModifierVideo existingModifier,
                                                                       CampaignType campaignType,
                                                                       @Nullable AdGroup adGroupWithType,
                                                                       ClientId clientId,
                                                                       CachingFeaturesProvider featuresProvider) {
        ItemValidationBuilder<BidModifierVideo, Defect> vb = ItemValidationBuilder.of(modifier);

        // Так как уже существует запись в hierarchicalMultiplier, то добавить туда уже ничего нельзя
        vb.getResult()
                .getOrCreateSubValidationResult(VIDEO_ADJUSTMENT, modifier.getVideoAdjustment())
                .addError(singleValueModifierAlreadyExists());

        return vb.getResult();
    }
}
