package ru.yandex.direct.core.entity.bids.container;

import java.util.EnumSet;

/**
 * Набор утилитных методов для работы с объектами {@link SetBidItem}
 * и {@link SetAutoBidItem}
 */
public class BidUtils {
    /**
     * @return количество заполненных Id полей на {@code bid}
     */
    public static int fieldCount(BidSelectionCriteria setBidItem) {
        int fieldCount;
        fieldCount = (setBidItem.getId() == null ? 0 : 1)
                + (setBidItem.getAdGroupId() == null ? 0 : 1)
                + (setBidItem.getCampaignId() == null ? 0 : 1);
        return fieldCount;
    }

    /**
     * @return {@code true} если на объекте {@code bid} задано ровно одно поле с Id
     * ({@code id}/{@code adGroupId}/{@code campaignId}), {@code false} в противном случае
     */
    public static boolean validIdField(BidSelectionCriteria setBidItem) {
        return fieldCount(setBidItem) == 1;
    }

    /**
     * Содержит ли {@code scope} перечисление элементов для установки ставки на Поиске
     */
    public static boolean containsSearch(EnumSet<BidTargetType> scopes) {
        return scopes.contains(BidTargetType.SEARCH) || scopes.contains(BidTargetType.SEARCH_BY_TRAFFIC_VOLUME);
    }
}
