package ru.yandex.direct.core.entity.bids.container;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.auction.container.bs.BsDataWithKeyword;
import ru.yandex.direct.core.entity.bids.model.Bid;
import ru.yandex.direct.core.entity.campaign.model.Campaign;

/**
 * Полная информация о ставке. Включает в себя статическую информацию из базы
 * и динамическую &ndash; из соседних сервисов.
 */
public class CompleteBidData<M extends BsDataWithKeyword> {

    private Bid bid;
    private AdGroup adGroup;
    private Campaign campaign;
    private KeywordBidDynamicData<M> dynamicData;

    /**
     * @return {@code getBid().getId()}
     */
    public Long getBidId() {
        return getBid().getId();
    }

    public Bid getBid() {
        return bid;
    }

    public CompleteBidData<M> withBid(Bid bid) {
        this.bid = bid;
        return this;
    }

    public AdGroup getAdGroup() {
        return adGroup;
    }

    public CompleteBidData<M> withAdGroup(final AdGroup adGroup) {
        this.adGroup = adGroup;
        return this;
    }

    public Campaign getCampaign() {
        return campaign;
    }

    public CompleteBidData<M> withCampaign(final Campaign campaign) {
        this.campaign = campaign;
        return this;
    }

    public KeywordBidDynamicData<M> getDynamicData() {
        return dynamicData;
    }

    public CompleteBidData<M> withDynamicData(KeywordBidDynamicData<M> dynamicData) {
        this.dynamicData = dynamicData;
        return this;
    }

}
