package ru.yandex.direct.core.entity.bids.container;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import ru.yandex.direct.model.ModelProperty;

/**
 * Класс для маппинга названий полей ядра и интерфейсов для установки и получения ставок
 */
public class ExternalFieldsBidsMapping {

    private final ImmutableMap<ModelProperty, String> externalFieldsMapping;

    public ExternalFieldsBidsMapping(ImmutableMap<ModelProperty, String> externalFieldsMapping) {
        this.externalFieldsMapping = externalFieldsMapping;
    }

    public static Builder builder(ExternalFieldsBidsMapping fallback) {
        return new Builder(EntryStream.of(fallback.externalFieldsMapping).toMap());
    }

    public static Builder builder() {
        return new Builder(new HashMap<>());
    }

    public String getBidsFields(List<ModelProperty<?, ?>> fields) {
        return StreamEx.of(fields)
                .map(this::getBidsField)
                .joining(", ");
    }

    public String getBidsField(ModelProperty modelProperty) {
        return externalFieldsMapping.get(modelProperty);
    }

    public static class Builder {
        private Map<ModelProperty, String> externalFieldsMapping;


        private Builder(Map<ModelProperty, String> externalFieldsMapping) {
            this.externalFieldsMapping = externalFieldsMapping;
        }

        public Builder map(ModelProperty modelProperty, String externalId) {
            externalFieldsMapping.put(modelProperty, externalId);
            return this;
        }

        public ExternalFieldsBidsMapping build() {
            return new ExternalFieldsBidsMapping(ImmutableMap.copyOf(externalFieldsMapping));
        }

    }
}
