package ru.yandex.direct.core.entity.bids.container;

import ru.yandex.direct.core.entity.auction.container.bs.BsDataWithKeyword;
import ru.yandex.direct.core.entity.auction.container.bs.KeywordBidBsAuctionData;

/**
 * Данные по ставке, полученные из динамических источников: Торгов БК и Показометра
 */
public class KeywordBidDynamicData<M extends BsDataWithKeyword> {

    private Long bidId;
    private M bsAuctionData;
    private KeywordBidPokazometerData pokazometerData;

    public Long getBidId() {
        return bidId;
    }

    public KeywordBidDynamicData<M> withBidId(final Long bidId) {
        this.bidId = bidId;
        return this;
    }

    /**
     * {@link KeywordBidBsAuctionData} &ndash; данные от Торгов о текущей ставке и ценах входа на различные позиции
     */
    public M getBsAuctionData() {
        return bsAuctionData;
    }

    public KeywordBidDynamicData<M> withBsAuctionData(M bsAuctionData) {
        this.bsAuctionData = bsAuctionData;
        return this;
    }


    /**
     * {@link KeywordBidPokazometerData} &ndash; данные от Показометра о показах на Сети
     */
    public KeywordBidPokazometerData getPokazometerData() {
        return pokazometerData;
    }

    public KeywordBidDynamicData<M> withPokazometerData(KeywordBidPokazometerData pokazometerData) {
        this.pokazometerData = pokazometerData;
        return this;
    }

}
