package ru.yandex.direct.core.entity.bids.container;

import java.util.Map;

import ru.yandex.direct.currency.Money;
import ru.yandex.direct.pokazometer.PhraseResponse;

/**
 * Связывает фразу с результатом, полученным для неё от Показометра.
 *
 * @see ru.yandex.direct.pokazometer.PokazometerClient
 */
public class KeywordBidPokazometerData {
    private final Long keywordId;
    private final Map<PhraseResponse.Coverage, Money> coverageWithPrices;
    private final Map<Money, Integer> allCostsAndClicks;

    public KeywordBidPokazometerData(Long keywordId,
                                     Map<PhraseResponse.Coverage, Money> coverageWithPrices,
                                     Map<Money, Integer> allCostsAndClicks) {
        this.keywordId = keywordId;
        this.coverageWithPrices = coverageWithPrices;
        this.allCostsAndClicks = allCostsAndClicks;
    }

    public KeywordBidPokazometerData(Long keywordId,
                                     Map<PhraseResponse.Coverage, Money> coverageWithPrices) {
        this(keywordId, coverageWithPrices, null);
    }

    public Long getKeywordId() {
        return keywordId;
    }

    public Map<PhraseResponse.Coverage, Money> getCoverageWithPrices() {
        return coverageWithPrices;
    }

    public Map<Money, Integer> getAllCostsAndClicks() {
        return allCostsAndClicks;
    }
}
