package ru.yandex.direct.core.entity.bids.container;

import java.math.BigDecimal;
import java.util.Objects;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

public class SetBidItem implements ModelWithId, BidSelectionCriteria {
    /**
     * id условия показа
     */
    public static final ModelProperty<SetBidItem, Long> ID =
            ModelProperty.create(SetBidItem.class, "id", SetBidItem::getId, SetBidItem::setId);

    /**
     * id группы, в которой будет произведен поиск условий показа
     */
    public static final ModelProperty<SetBidItem, Long> AD_GROUP_ID =
            ModelProperty.create(SetBidItem.class, "adGroupId", SetBidItem::getAdGroupId, SetBidItem::setAdGroupId);

    /**
     * id кампании, в которой будет произведен поиск условий показа
     */
    public static final ModelProperty<SetBidItem, Long> CAMPAIGN_ID =
            ModelProperty.create(SetBidItem.class, "campaignId", SetBidItem::getCampaignId, SetBidItem::setCampaignId);

    /**
     * ставка на поиске
     */
    public static final ModelProperty<SetBidItem, BigDecimal> PRICE_SEARCH =
            ModelProperty
                    .create(SetBidItem.class, "priceSearch", SetBidItem::getPriceSearch, SetBidItem::setPriceSearch);

    /**
     * ставка на площадках
     */
    public static final ModelProperty<SetBidItem, BigDecimal> PRICE_CONTEXT =
            ModelProperty
                    .create(SetBidItem.class, "priceContext", SetBidItem::getPriceContext, SetBidItem::setPriceContext);

    /**
     * приоритет автобюджета
     */
    public static final ModelProperty<SetBidItem, Integer> AUTOBUDGET_PRIORITY =
            ModelProperty.create(SetBidItem.class, "autobudgetPriority", SetBidItem::getAutobudgetPriority,
                    SetBidItem::setAutobudgetPriority);

    private Long id;

    private Long adGroupId;

    private Long campaignId;

    private BigDecimal priceSearch;

    private BigDecimal priceContext;

    private Integer autobudgetPriority;

    private ShowConditionType showConditionType;

    /**
     * id условия показа
     */
    @Override
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SetBidItem withId(Long id) {
        setId(id);
        return this;
    }

    /**
     * id группы, в которой будет произведен поиск условий показа
     */
    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public SetBidItem withAdGroupId(Long adGroupId) {
        setAdGroupId(adGroupId);
        return this;
    }

    /**
     * id кампании, в которой будет произведен поиск условий показа
     */
    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public SetBidItem withCampaignId(Long campaignId) {
        setCampaignId(campaignId);
        return this;
    }

    /**
     * ставка на поиске
     */
    public BigDecimal getPriceSearch() {
        return priceSearch;
    }

    public void setPriceSearch(BigDecimal priceSearch) {
        this.priceSearch = priceSearch;
    }

    public SetBidItem withPriceSearch(BigDecimal priceSearch) {
        setPriceSearch(priceSearch);
        return this;
    }

    /**
     * ставка на площадках
     */
    public BigDecimal getPriceContext() {
        return priceContext;
    }

    public void setPriceContext(BigDecimal priceContext) {
        this.priceContext = priceContext;
    }

    public SetBidItem withPriceContext(BigDecimal priceContext) {
        setPriceContext(priceContext);
        return this;
    }

    /**
     * приоритет автобюджета
     */
    public Integer getAutobudgetPriority() {
        return autobudgetPriority;
    }

    public void setAutobudgetPriority(Integer autobudgetPriority) {
        this.autobudgetPriority = autobudgetPriority;
    }

    public SetBidItem withAutobudgetPriority(Integer autobudgetPriority) {
        setAutobudgetPriority(autobudgetPriority);
        return this;
    }

    /**
     * Типы площадок, которые поддерживаются для условия показа
     */
    public ShowConditionType getShowConditionType() {
        return showConditionType;
    }

    public void setShowConditionType(ShowConditionType showConditionType) {
        this.showConditionType = showConditionType;
    }

    public SetBidItem withShowConditionType(ShowConditionType showConditionType) {
        setShowConditionType(showConditionType);
        return this;
    }

    @Override
    public String toString() {
        return "SetBidItem{" +
                "id=" + id +
                ", adGroupId=" + adGroupId +
                ", campaignId=" + campaignId +
                ", priceSearch=" + priceSearch +
                ", priceContext=" + priceContext +
                ", autobudgetPriority=" + autobudgetPriority +
                ", showConditionType=" + showConditionType +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SetBidItem that = (SetBidItem) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(adGroupId, that.adGroupId) &&
                Objects.equals(campaignId, that.campaignId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, adGroupId, campaignId);
    }
}
