package ru.yandex.direct.core.entity.bids.container.interpolator;

import java.util.List;

import ru.yandex.direct.utils.math.Point;

/**
 * Колпак -- сущность для измнения сглаживания.
 * points -- массив пар, где первый элемент пары -- это шаг, определяет сдвиг
 * относительно исходной координаты для новых точек.
 * второй элемент пары -- доля от роста ступени.
 */
public class Cap {
    private List<Point> points;

    private Cap(List<Point> points) {
        this.points = points;
    }

    public static Cap fromPoints(List<Point> points) {
        return new Cap(points);
    }

    public List<Point> getPoints() {
        return points;
    }

    public int size() {
        return points.size();
    }
}
