package ru.yandex.direct.core.entity.bids.container.interpolator;

import java.util.Objects;

public class CapKey {
    //в кавычках ли фраза
    private boolean isExactMatch;
    //превышает ли максимальный traffic_volume 1/2 * 1_000_000
    private int typeId;
    //домен баннера
    private String domain;

    public CapKey(boolean isExactMatch, int typeId, String domain) {
        this.isExactMatch = isExactMatch;
        this.typeId = typeId;
        this.domain = domain;
    }

    public boolean isExactMatch() {
        return isExactMatch;
    }

    public int getTypeId() {
        return typeId;
    }

    public String getDomain() {
        return domain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CapKey)) {
            return false;
        }
        CapKey capKey = (CapKey) o;
        return isExactMatch() == capKey.isExactMatch() &&
                getTypeId() == capKey.getTypeId() &&
                Objects.equals(getDomain(), capKey.getDomain());
    }

    @Override
    public int hashCode() {
        return Objects.hash(isExactMatch(), getTypeId(), getDomain());
    }
}
